/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.preferences;

import ch.elexis.core.services.IConfigService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.mednet.webapi.core.messages.Messages;
import jakarta.inject.Inject;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class MedNetWebPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    @Inject
    private IConfigService configService;
    private Button demoRadioButton;
    private Button produktivRadioButton;
    public static final String DEMO = "DEMO";
    public static final String PRODUKTIV = "PRODUKTIV";

    public MedNetWebPreferencePage() {
        super(1);
        CoreUiUtil.injectServices((Object)((Object)this));
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "ch.elexis.mednet.webapi.ui");
        this.setPreferenceStore((IPreferenceStore)preferenceStore);
        this.setDescription(Messages.MedNetWebPreferencePage_configForMedNetWebAPI);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new DirectoryFieldEditor("MedNetDownloadpathPreference", Messages.MedNetWebPreferencePage_downloadFolder, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("MedNetUserStringPreference", Messages.MedNetWebPreferencePage_loginName, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("mednet.confirmBeforeSend", Messages.MedNetWebPreferencePage_confirmBeforeSend, this.getFieldEditorParent()));
        this.createRadioButtonGroup(this.getFieldEditorParent());
    }

    private void createRadioButtonGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.MedNetWebPreferencePage_operatingMode);
        group.setLayout((Layout)new GridLayout(1, false));
        this.demoRadioButton = new Button((Composite)group, 16);
        this.demoRadioButton.setText(Messages.MedNetWebPreferencePage_demoMode);
        this.demoRadioButton.setSelection(DEMO.equals(this.getPreferenceStore().getString("mednet_mode")));
        this.produktivRadioButton = new Button((Composite)group, 16);
        this.produktivRadioButton.setText(Messages.MedNetWebPreferencePage_produktivMode);
        this.produktivRadioButton.setSelection(PRODUKTIV.equals(this.getPreferenceStore().getString("mednet_mode")));
    }

    public void init(IWorkbench workbench) {
        if (this.configService != null) {
            String downloadPath = this.configService.getActiveUserContact("MedNetDownloadpathPreference", "");
            this.getPreferenceStore().setValue("MedNetDownloadpathPreference", downloadPath);
            String userName = this.configService.getActiveUserContact("MedNetUserStringPreference", "");
            this.getPreferenceStore().setValue("MedNetUserStringPreference", userName);
            String mode = this.configService.getActiveUserContact("mednet_mode", DEMO);
            this.getPreferenceStore().setValue("mednet_mode", mode);
            String confirm = this.configService.getActiveUserContact("mednet.confirmBeforeSend", "true");
            this.getPreferenceStore().setValue("mednet.confirmBeforeSend", Boolean.parseBoolean(confirm));
        }
    }

    public boolean performOk() {
        String previousMode = this.getPreferenceStore().getString("mednet_mode");
        String selectedMode = this.demoRadioButton.getSelection() ? DEMO : PRODUKTIV;
        this.getPreferenceStore().setValue("mednet_mode", selectedMode);
        this.configService.setActiveUserContact("mednet_mode", selectedMode);
        if (!previousMode.equals(selectedMode)) {
            this.configService.setActiveMandator("mednet/auth/token/mednet", null);
            this.configService.setActiveMandator("mednet/auth/refreshtoken/mednet", null);
            this.configService.setActiveMandator("mednet/auth/tokenexpires/mednet", null);
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.MedNetMainComposite_restartRequiredTitle, (String)Messages.MedNetMainComposite_restartRequiredMessage);
        }
        boolean result = super.performOk();
        this.applyChanges();
        return result;
    }

    protected void performApply() {
        super.performApply();
        this.applyChanges();
    }

    private void applyChanges() {
        if (this.configService != null) {
            this.configService.setActiveUserContact("MedNetDownloadpathPreference", this.getPreferenceStore().getString("MedNetDownloadpathPreference"));
            this.configService.setActiveUserContact("MedNetUserStringPreference", this.getPreferenceStore().getString("MedNetUserStringPreference"));
            this.configService.setActiveUserContact("mednet.confirmBeforeSend", Boolean.toString(this.getPreferenceStore().getBoolean("mednet.confirmBeforeSend")));
        }
    }
}

