/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.handler;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.mednet.webapi.ui.handler.ImportOmnivoreUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportOmnivore {
    private final Pattern PATIENT_MATCH_PATTERN = Pattern.compile("([0-9]+)_(.+)");
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ImportOmnivoreUtil giutil = new ImportOmnivoreUtil();

    public IStatus run() {
        String filepath = this.getdownload();
        File dir = null;
        if (filepath == null) {
            filepath = "MedNetDownloadpathPreference";
            ConfigServiceHolder.get().setLocal("ch.elexis.mednet.webapi.ui", "MedNetDownloadpathPreference");
        }
        try {
            Path path = Paths.get(filepath, new String[0]);
            dir = path.toFile();
        }
        catch (Exception e) {
            return Status.CANCEL_STATUS;
        }
        this.addFilesInDirRecursive(dir);
        return Status.OK_STATUS;
    }

    private void addFilesInDirRecursive(File dir) {
        ArrayList<String> allFilesInDirRecursive = new ArrayList<String>();
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isHidden() && !file.getName().startsWith(".")) {
                if (file.isDirectory()) {
                    this.addFilesInDirRecursive(file);
                } else {
                    allFilesInDirRecursive.add(file.getAbsolutePath());
                }
                if (file.isDirectory()) {
                    this.addFilesInDirRecursive(file);
                } else {
                    String fileName;
                    String patientNo;
                    String tryImportForPatient;
                    Matcher matcher = this.PATIENT_MATCH_PATTERN.matcher(file.getName());
                    if (matcher.matches() && (tryImportForPatient = this.giutil.tryImportForPatient(file, patientNo = matcher.group(1), fileName = matcher.group(2))) != null) {
                        this.log.info("Auto imported file [{}], document id is [{}]", (Object)file, (Object)tryImportForPatient);
                    } else {
                        allFilesInDirRecursive.add(file.getAbsolutePath());
                    }
                }
            }
            ++n2;
        }
        allFilesInDirRecursive.sort(Comparator.comparingInt(String::length));
        ArrayList<File> extensionFiles = new ArrayList<File>();
        for (String string : allFilesInDirRecursive) {
            File file = new File(string);
            if (extensionFiles.contains(file)) continue;
            File[] _extensionFiles = dir.listFiles((_dir, _name) -> _name.startsWith(file.getName()) && !Objects.equals(_name, file.getName()));
            extensionFiles.addAll(Arrays.asList(_extensionFiles));
        }
    }

    private String getdownload() {
        try {
            String pluginId = "ch.elexis.mednet.webapi.ui";
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode(pluginId);
            String downloadPath = node.get("MedNetDownloadpathPreference", "");
            return downloadPath;
        }
        catch (Exception e) {
            return "";
        }
    }
}

