/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources.util;

import ch.elexis.core.services.IConfigService;
import ch.elexis.mednet.webapi.core.IMednetAuthService;
import ch.elexis.mednet.webapi.core.constants.ApiConstants;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloader {
    private static final Logger logger = LoggerFactory.getLogger(FileDownloader.class);
    private IMednetAuthService authService;

    public FileDownloader(IMednetAuthService authService) {
        this.authService = authService;
    }

    public boolean downloadForms() {
        boolean success = false;
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMednetAuthService.class);
        if (serviceReference != null) {
            this.authService = (IMednetAuthService)context.getService(serviceReference);
            try {
                try {
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("token_group", "mednet");
                    Optional<String> authToken = this.authService.getToken(parameters);
                    if (authToken.isPresent()) {
                        String token = authToken.get();
                        List<Integer> customerIds = this.fetchCustomerIds(token);
                        if (!customerIds.isEmpty()) {
                            success = true;
                            for (Integer customerId : customerIds) {
                                this.fetchAndDownloadFormsForCustomer(token, customerId);
                            }
                        }
                        logger.error("No customer IDs found.");
                    }
                    logger.error("No authentication token received.");
                }
                catch (Exception ex) {
                    logger.error("An error occurred while retrieving the forms: {}", (Object)ex.getMessage());
                    context.ungetService(serviceReference);
                }
            }
            finally {
                context.ungetService(serviceReference);
            }
        } else {
            logger.error("ServiceReference for IMednetAuthService is null.");
        }
        return success;
    }

    private List<Integer> fetchCustomerIds(String token) {
        ArrayList<Integer> customerIds = new ArrayList<Integer>();
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(ApiConstants.getBaseApiUrl() + "/customers?includeDetails=true")).header("Authorization", "Bearer " + token).GET().build();
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                String responseBody = response.body();
                JsonArray customersArray = JsonParser.parseString((String)responseBody).getAsJsonArray();
                int i = 0;
                while (i < customersArray.size()) {
                    JsonObject customer = customersArray.get(i).getAsJsonObject();
                    int customerId = customer.get("id").getAsInt();
                    customerIds.add(customerId);
                    ++i;
                }
                logger.info("Found {} customers.", (Object)customerIds.size());
            } else {
                logger.error("API request failed. Status Code: {}", (Object)response.statusCode());
            }
        }
        catch (Exception ex) {
            logger.error("An error occurred while fetching customer IDs: {}", (Object)ex.getMessage());
        }
        return customerIds;
    }

    private void fetchAndDownloadFormsForCustomer(String token, Integer customerId) {
        try {
            String apiUrl = String.format(ApiConstants.getBaseApiUrl() + "/submitted-forms?customerId=%d", customerId);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Authorization", "Bearer " + token).GET().build();
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                String responseBody = response.body();
                this.downloadFilesFromResponse(responseBody, token);
            }
        }
        catch (Exception ex) {
            logger.error("An error occurred while fetching forms for customerId {}: {}", (Object)customerId, (Object)ex.getMessage());
        }
    }

    private void downloadFilesFromResponse(String responseBody, String token) {
        try {
            Gson gson = new Gson();
            Type listType = new TypeToken<List<Map<String, Object>>>(){}.getType();
            List formList = (List)gson.fromJson(responseBody, listType);
            System.out.println("formList " + String.valueOf(formList));
            for (Map form : formList) {
                String packageId = (String)form.get("packageId");
                String externalPatientId = (String)form.get("externalPatientId");
                String patientFirstName = (String)form.get("patientFirstName");
                String patientLastName = (String)form.get("patientLastName");
                String patientName = patientLastName + " " + patientFirstName;
                String title = (String)form.get("title");
                Map customer = (Map)form.get("customer");
                Map provider = (Map)form.get("provider");
                String receiver = (String)provider.get("lastName");
                String sender = (String)customer.get("lastName");
                if (!form.containsKey("files")) continue;
                List files = (List)form.get("files");
                for (Map file : files) {
                    String downloadUrl = (String)file.get("downloadUrl");
                    String createDate = FileDownloader.extractDateFromUrl(downloadUrl);
                    String objectId = (String)file.get("objectId");
                    if (downloadUrl != null && objectId != null && packageId != null) {
                        String sanitizedCreateDate = createDate.replaceAll("[\\\\/:*?\"<>|]", "_");
                        String sanitizedPatientName = patientName.replaceAll("[\\\\/:*?\"<>|]", "_");
                        String sanitizedTitle = title.replaceAll("[\\\\/:*?\"<>|]", "_");
                        String sanitizedReceiver = receiver.replaceAll("[\\\\/:*?\"<>|]", "_");
                        String sanitizedSender = sender.replaceAll("[\\\\/:*?\"<>|]", "_");
                        String fileName = externalPatientId + "_" + sanitizedPatientName + "_" + sanitizedTitle + "_" + sanitizedSender + "_" + sanitizedReceiver + "_" + sanitizedCreateDate + ".pdf";
                        this.downloadFile(downloadUrl, fileName, packageId, token, (List)file.get("downloadHeaders"), externalPatientId);
                        continue;
                    }
                    logger.error("Missing download URL, object ID, or package ID.");
                }
            }
        }
        catch (Exception ex) {
            logger.error("An error occurred while processing the response: {}", (Object)ex.getMessage());
        }
    }

    private void downloadFile(String downloadUrl, String fileName, String packageId, String token, List<Map<String, String>> downloadHeadersList, String externalPatientId) {
        try {
            Path filePath;
            String downloadPath = this.getDownloadStore();
            File directory = new File(downloadPath);
            if (!directory.exists()) {
                boolean dirCreated = directory.mkdirs();
                if (dirCreated) {
                    logger.info("Download directory created: {}", (Object)downloadPath);
                } else {
                    logger.error("Could not create the download directory: {}", (Object)downloadPath);
                    return;
                }
            }
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(downloadUrl)).GET();
            if (downloadHeadersList != null) {
                for (Map<String, String> header : downloadHeadersList) {
                    String key = header.get("key");
                    String value = header.get("value");
                    if (key == null || value == null) continue;
                    requestBuilder.header(key, value);
                }
            }
            HttpRequest request = requestBuilder.build();
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<Path> response = client.send(request, HttpResponse.BodyHandlers.ofFile(filePath = Paths.get(downloadPath, fileName)));
            if (response.statusCode() == 200) {
                this.acknowledgeDownloadSuccess(packageId, token);
                logger.info("File downloaded successfully: {}", (Object)filePath.toString());
            } else {
                this.acknowledgeDownloadFailure(packageId, token, "Download fehlgeschlagen");
                logger.error("Error downloading the file. Status code: {}", (Object)response.statusCode());
            }
        }
        catch (Exception ex) {
            logger.error("An error occurred during the download: {}", (Object)ex.getMessage());
        }
    }

    private static String extractDateFromUrl(String url) {
        String pattern = "(\\d{14})";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(url);
        if (m.find()) {
            String dateString = m.group(0);
            String year = dateString.substring(0, 4);
            String month = dateString.substring(4, 6);
            String day = dateString.substring(6, 8);
            String hour = dateString.substring(8, 10);
            String minute = dateString.substring(10, 12);
            return day + "." + month + "." + year + " " + hour + ":" + minute;
        }
        return "Unknown Date";
    }

    private void acknowledgeDownloadSuccess(String packageId, String token) {
        try {
            String successUrl = ApiConstants.getBaseApiUrl() + "/" + packageId + "/download-success?objectType=Form";
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(successUrl)).header("Authorization", "Bearer " + token).method("PATCH", HttpRequest.BodyPublishers.noBody()).build();
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                logger.info("Download successfully confirmed for package ID: " + packageId);
            }
        }
        catch (Exception ex) {
            logger.error("An error occurred while confirming the download: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void acknowledgeDownloadFailure(String packageId, String token, String errorMessage) {
        try {
            String failureUrl = ApiConstants.getBaseApiUrl() + "/" + packageId + "/download-failure?objectType=Form";
            String jsonBody = "{ \"errorMessage\": \"" + errorMessage.replace("\"", "\\\"") + "\" }";
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(failureUrl)).header("Authorization", "Bearer " + token).header("Content-Type", "application/json").method("PATCH", HttpRequest.BodyPublishers.ofString(jsonBody)).build();
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200 || response.statusCode() == 204) {
                logger.info("Download failure successfully acknowledged for package ID: {}", (Object)packageId);
            } else {
                logger.error("Failed to acknowledge download failure for package ID: {}. Status Code: {}", (Object)packageId, (Object)response.statusCode());
            }
        }
        catch (Exception ex) {
            logger.error("An error occurred while acknowledging the download failure: {}", (Object)ex.getMessage());
        }
    }

    private String getDownloadStore() {
        try {
            IConfigService configService;
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IConfigService.class);
            if (serviceReference != null && (configService = (IConfigService)context.getService(serviceReference)) != null) {
                String downloadPath = configService.getActiveUserContact("MedNetDownloadpathPreference", "");
                if (downloadPath == null || downloadPath.trim().isEmpty()) {
                    logger.warn("No download path found in preferences.");
                } else {
                    logger.info("Download path retrieved: {}", (Object)downloadPath);
                }
                return downloadPath;
            }
        }
        catch (Exception e) {
            logger.error("Error when retrieving the download path from the preferences: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
        return null;
    }
}

