/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.constants;

import ch.elexis.core.rcp.utils.OsgiServiceUtil;
import ch.elexis.core.services.IConfigService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiConstants {
    private static final Logger logger = LoggerFactory.getLogger(ApiConstants.class);
    public static final String BASE_REDERICT_URI = "https://tools.medelexis.ch/mednet/ac";
    public static final String BASE_REDERICT_URI_OBTAIN = "https://tools.medelexis.ch/mednet/ac-obtain/";
    public static final String CUSTOMERS_URL = "/customers?includeDetails=true";
    public static final String PROVIDERS_URL = "/providers?customerId=%d&includeDetails=true";
    public static final String FORMS_URL = "/forms?customerId=%d&providerId=%d";
    public static final String SUBMITTED_FORMS_URL = "/submitted-forms?customerId=%d";
    public static final String PATIENTS_URL = "/patients";

    public static String getBaseApiUrl() {
        Optional configService = OsgiServiceUtil.getServiceWait(IConfigService.class, (long)5000L);
        if (configService.isPresent()) {
            String mode = ((IConfigService)configService.get()).getActiveUserContact("mednet_mode", "DEMO");
            if ("PRODUKTIV".equals(mode)) {
                return "https://www.mednet.swiss/web/api/v1/external";
            }
            return "https://demo.mednet.swiss/web/api/v1/external";
        }
        logger.error("Error when retrieving the base API URL from the preferences: {}");
        return "https://demo.mednet.swiss/web/api/v1/external";
    }

    public static String getBaseUri() {
        Optional configService = OsgiServiceUtil.getServiceWait(IConfigService.class, (long)5000L);
        if (configService.isPresent()) {
            String mode = ((IConfigService)configService.get()).getActiveUserContact("mednet_mode", "DEMO");
            if ("PRODUKTIV".equals(mode)) {
                return "https://www.mednetpatient.swiss/idsrv";
            }
            return "https://demo.mednetpatient.swiss/idsrv";
        }
        return "https://demo.mednetpatient.swiss/idsrv";
    }
}

