/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IRelatedContact;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.LocalizeUtil;
import ch.elexis.core.types.RelationshipType;
import ch.elexis.mednet.webapi.core.fhir.resources.OrganizationResource;
import ch.elexis.mednet.webapi.core.fhir.resources.util.FhirResourceFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.eclipse.emf.common.util.Enumerator;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;

public class PatientResource {
    public static void addTelecomInformation(IPatient source, Patient target) {
        ArrayList<ContactPoint> telecomList = new ArrayList<ContactPoint>();
        if (source.getMobile() != null && !source.getMobile().isEmpty()) {
            telecomList.add(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.PHONE).setUse(ContactPoint.ContactPointUse.MOBILE).setRank(1).setValue(source.getMobile()));
        }
        if (source.getPhone1() != null && !source.getPhone1().isEmpty()) {
            telecomList.add(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.PHONE).setUse(ContactPoint.ContactPointUse.HOME).setRank(2).setValue(source.getPhone1()));
        }
        if (source.getPhone2() != null && !source.getPhone2().isEmpty()) {
            telecomList.add(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.PHONE).setUse(ContactPoint.ContactPointUse.TEMP).setRank(3).setValue(source.getPhone2()));
        }
        if (source.getEmail() != null && !source.getEmail().isEmpty()) {
            telecomList.add(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.EMAIL).setUse(ContactPoint.ContactPointUse.HOME).setValue(source.getEmail()));
        }
        if (source.getFax() != null && !source.getFax().isEmpty()) {
            telecomList.add(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.FAX).setUse(ContactPoint.ContactPointUse.WORK).setValue(source.getFax()));
        }
        if (source.getWebsite() != null && !source.getWebsite().isEmpty()) {
            telecomList.add(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.URL).setUse(ContactPoint.ContactPointUse.WORK).setValue(source.getWebsite()));
        }
        target.setTelecom(telecomList);
    }

    public static void addContactInformation(IPatient source, Patient target, Bundle bundle, FhirResourceFactory resourceFactory) {
        ArrayList<Patient.ContactComponent> contacts = new ArrayList<Patient.ContactComponent>();
        List relatedContacts = source.getRelatedContacts();
        for (IRelatedContact relatedContact : relatedContacts) {
            IContact otherContact = relatedContact.getOtherContact();
            if (otherContact == null) continue;
            Patient.ContactComponent contactComponent = PatientResource.createContactComponent(relatedContact, otherContact, bundle);
            if (otherContact.isOrganization()) {
                String organizationId = otherContact.getId();
                String organizationFullUrl = "urn:uuid:" + UUID.nameUUIDFromBytes(organizationId.getBytes()).toString();
                if (bundle.getEntry().stream().noneMatch(entry -> organizationFullUrl.equals(entry.getFullUrl()))) {
                    Organization organization = OrganizationResource.createOrganization(otherContact, resourceFactory);
                    bundle.addEntry().setFullUrl(organizationFullUrl).setResource((Resource)organization);
                }
                contactComponent.setOrganization(new Reference(organizationFullUrl));
            }
            contacts.add(contactComponent);
        }
        target.setContact(contacts);
    }

    private static Patient.ContactComponent createContactComponent(IRelatedContact relatedContact, IContact otherContact, Bundle bundle) {
        Patient.ContactComponent contactComponent = new Patient.ContactComponent();
        String fhirCode = PatientResource.mapRelationshipToRoleCode(relatedContact.getOtherType());
        CodeableConcept relationship = new CodeableConcept().addCoding(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/v2-0131").setCode(fhirCode).setDisplay(relatedContact.getRelationshipDescription()));
        contactComponent.setRelationship(Collections.singletonList(relationship));
        if (otherContact.isPerson()) {
            IPerson person = (IPerson)CoreModelServiceHolder.get().load(otherContact.getId(), IPerson.class).get();
            HumanName humanName = new HumanName().setFamily(person.getLastName()).addGiven(person.getFirstName()).addPrefix(person.getTitel()).addSuffix(person.getTitelSuffix()).setUse(HumanName.NameUse.USUAL);
            contactComponent.setName(humanName);
            Enumerations.AdministrativeGender gender = Enumerations.AdministrativeGender.UNKNOWN;
            Gender personGender = person.getGender();
            if (personGender != null) {
                switch (personGender) {
                    case MALE: {
                        gender = Enumerations.AdministrativeGender.MALE;
                        break;
                    }
                    case FEMALE: {
                        gender = Enumerations.AdministrativeGender.FEMALE;
                        break;
                    }
                    default: {
                        gender = Enumerations.AdministrativeGender.UNKNOWN;
                    }
                }
            }
            contactComponent.setGender(gender);
            Address address = new Address().setUse(Address.AddressUse.HOME).addLine(otherContact.getStreet()).setCity(otherContact.getCity()).setPostalCode(otherContact.getZip()).setCountry(otherContact.getCountry() != null ? otherContact.getCountry().toString() : null);
            contactComponent.setAddress(address);
            ArrayList<ContactPoint> contactPoints = new ArrayList<ContactPoint>();
            if (otherContact.getMobile() != null) {
                contactPoints.add(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.PHONE).setValue(otherContact.getMobile()).setUse(ContactPoint.ContactPointUse.MOBILE));
            }
            if (otherContact.getPhone1() != null) {
                contactPoints.add(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.PHONE).setValue(otherContact.getPhone1()).setUse(ContactPoint.ContactPointUse.HOME));
            }
            if (otherContact.getPhone2() != null) {
                contactPoints.add(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.PHONE).setValue(otherContact.getPhone2()).setUse(ContactPoint.ContactPointUse.TEMP));
            }
            if (otherContact.getEmail() != null) {
                contactPoints.add(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.EMAIL).setValue(otherContact.getEmail()).setUse(ContactPoint.ContactPointUse.HOME));
            }
            contactComponent.setTelecom(contactPoints);
        }
        return contactComponent;
    }

    private static String mapRelationshipToRoleCode(RelationshipType relationshipType) {
        if (relationshipType == null) {
            return "U";
        }
        return switch (relationshipType) {
            case RelationshipType.FAMILY_PARENT -> "PRN";
            case RelationshipType.FAMILY_CHILD -> "CHILD";
            case RelationshipType.BUSINESS_EMPLOYER, RelationshipType.BUSINESS_EMPLOYEE -> "E";
            case RelationshipType.FAMILY_ICE -> "C";
            default -> "U";
        };
    }

    public static String[] getBezugKontaktTypes() {
        RelationshipType[] allRelationshipTypes = RelationshipType.values();
        String[] displayValues = new String[allRelationshipTypes.length];
        int idx = 0;
        RelationshipType[] relationshipTypeArray = allRelationshipTypes;
        int n = allRelationshipTypes.length;
        int n2 = 0;
        while (n2 < n) {
            RelationshipType relationshipType = relationshipTypeArray[n2];
            displayValues[idx++] = LocalizeUtil.getLocaleText((Enumerator)relationshipType);
            ++n2;
        }
        return displayValues;
    }
}

