/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import java.util.Date;
import java.util.UUID;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;

public class CompositionResource {
    public static Composition createComposition(Patient patient) {
        Composition composition = new Composition();
        composition.setId(UUID.randomUUID().toString());
        composition.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-patientOverview-composition");
        composition.setStatus(Composition.CompositionStatus.FINAL);
        composition.setType(new CodeableConcept().addCoding(new Coding("http://loinc.org", "60591-5", "Patient summary Document")));
        composition.setTitle("PatientOverview");
        composition.setDate(new Date());
        String patientReference = "urn:uuid:" + patient.getId();
        composition.setSubject(new Reference(patientReference));
        composition.setConfidentiality(Composition.DocumentConfidentiality.N);
        return composition;
    }
}

