/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources.util;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import java.io.File;

public class OmnivoreUtil {
    private static final String STOREFSGLOBAL = "ch.elexis.omnivore/store_in_fs_global";
    private static final String STOREFS = "ch.elexis.omnivore/store_in_fs";
    private static final String BASEPATH = "ch.elexis.omnivore/basepath";

    private static boolean isGlobalConfig() {
        return ConfigServiceHolder.getGlobal((String)STOREFSGLOBAL, (boolean)false);
    }

    public static boolean storeInFilesystem() {
        return OmnivoreUtil.isGlobalConfig() ? ConfigServiceHolder.getGlobal((String)STOREFS, (boolean)false) : ConfigServiceHolder.getLocal((String)STOREFS, (boolean)false);
    }

    public static String getBasepath() {
        String ret;
        String string = ret = OmnivoreUtil.isGlobalConfig() ? ConfigServiceHolder.getGlobal((String)BASEPATH, (String)"") : ConfigServiceHolder.getLocal((String)BASEPATH, (String)"");
        if (ret.contains("no protocol: ")) {
            ret = ret.replaceAll("no protocol: ", "");
        }
        return ret;
    }

    public static boolean isBasePathSet() {
        return OmnivoreUtil.isGlobalConfig() ? ConfigServiceHolder.getGlobal((String)BASEPATH, null) != null : ConfigServiceHolder.getLocal((String)BASEPATH, null) != null;
    }

    public static boolean isValidDocumentsDirectory(File documentsDirectory) {
        return documentsDirectory.exists() && documentsDirectory.isDirectory() && OmnivoreUtil.hasTextSubdirectory(documentsDirectory);
    }

    private static boolean hasTextSubdirectory(File documentsDirectory) {
        File[] subFiles = documentsDirectory.listFiles();
        if (subFiles != null) {
            File[] fileArray = subFiles;
            int n = subFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String lowerName;
                File file = fileArray[n2];
                if (file != null && file.isDirectory() && (lowerName = file.getName().toLowerCase()).contains("texte") && Character.isDigit(lowerName.charAt(0))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

