/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.util.FindingsServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.mednet.webapi.core.fhir.resources.util.FhirResourceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;

public class AllergyIntoleranceResource {
    public static List<AllergyIntolerance> createAllergies(Patient patient, IPatient sourcePatient, FhirResourceFactory resourceFactory) {
        ArrayList<AllergyIntolerance> allergies;
        block12: {
            String patientFullUrl;
            block11: {
                allergies = new ArrayList<AllergyIntolerance>();
                patientFullUrl = "urn:uuid:" + patient.getIdElement().getIdPart();
                boolean strukturAllergy = ConfigServiceHolder.getGlobal((String)"allergyintolerance/settings/useStructured", (boolean)false);
                if (!strukturAllergy) break block11;
                List structuredAllergies = FindingsServiceHolder.getiFindingsService().getPatientsFindings(sourcePatient.getId(), IAllergyIntolerance.class);
                for (IAllergyIntolerance structuredAllergy : structuredAllergies) {
                    AllergyIntolerance allergy = resourceFactory.getResource(structuredAllergy, IAllergyIntolerance.class, AllergyIntolerance.class);
                    if (allergy == null) {
                        allergy = new AllergyIntolerance();
                        allergy.setId(UUID.randomUUID().toString());
                    }
                    if (allergy.getId() == null || allergy.getId().isEmpty()) {
                        allergy.setId(UUID.randomUUID().toString());
                    }
                    allergy.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-allergyIntolerance");
                    if (allergy.getClinicalStatus() == null || allergy.getClinicalStatus().isEmpty()) {
                        CodeableConcept cs = new CodeableConcept().addCoding(new Coding("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "active", "Active"));
                        allergy.setClinicalStatus(cs);
                    }
                    if (allergy.getVerificationStatus() == null || allergy.getVerificationStatus().isEmpty()) {
                        CodeableConcept vs = new CodeableConcept().addCoding(new Coding("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "confirmed", "Confirmed"));
                        allergy.setVerificationStatus(vs);
                    }
                    if (allergy.getCode() == null || allergy.getCode().getCoding().isEmpty()) {
                        allergy.setCode(new CodeableConcept().setText(structuredAllergy.getText().orElse("Unknown Allergy")));
                    }
                    allergy.setPatient(new Reference(patientFullUrl));
                    allergies.add(allergy);
                }
                break block12;
            }
            String patientAllergies = sourcePatient.getAllergies();
            if (patientAllergies == null || patientAllergies.isEmpty()) break block12;
            List<String> allergyList = Arrays.asList(patientAllergies.split(","));
            for (String allergyText : allergyList) {
                IAllergyIntolerance sourceAllergy = (IAllergyIntolerance)FindingsServiceHolder.getiFindingsService().create(IAllergyIntolerance.class);
                sourceAllergy.setPatientId(sourcePatient.getId());
                sourceAllergy.setText(allergyText.trim());
                AllergyIntolerance allergy = resourceFactory.getResource(sourceAllergy, IAllergyIntolerance.class, AllergyIntolerance.class);
                if (allergy == null) {
                    allergy = new AllergyIntolerance();
                    allergy.setId(UUID.randomUUID().toString());
                }
                if (allergy.getId() == null || allergy.getId().isEmpty()) {
                    allergy.setId(UUID.randomUUID().toString());
                }
                allergy.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-allergyIntolerance");
                if (allergy.getClinicalStatus() == null) {
                    CodeableConcept clinicalStatus = new CodeableConcept();
                    clinicalStatus.addCoding(new Coding("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "active", "Active"));
                    allergy.setClinicalStatus(clinicalStatus);
                }
                if (allergy.getCode() == null || allergy.getCode().getCoding().isEmpty()) {
                    CodeableConcept code = new CodeableConcept();
                    code.addCoding(new Coding("http://snomed.info/sct", "781474001", "Allergic disorder (disorder)"));
                    code.setText(allergyText.trim());
                    allergy.setCode(code);
                }
                allergy.setPatient(new Reference(patientFullUrl));
                allergies.add(allergy);
            }
        }
        return allergies;
    }
}

