/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class AnnotationResource {
    public static List<Observation> createAnnotations(Reference patientReference) {
        ArrayList<Observation> annotations = new ArrayList<Observation>();
        Observation annotation = new Observation();
        annotation.setId(UUID.randomUUID().toString());
        annotation.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-obs-annotation");
        annotation.setStatus(Observation.ObservationStatus.FINAL);
        annotation.addCategory(new CodeableConcept().setText("Consultation"));
        annotation.setCode(new CodeableConcept().addCoding(new Coding().setSystem("http://loinc.org").setCode("48767-8").setDisplay("Annotation comment [Interpretation] Narrative")));
        annotation.setSubject(patientReference);
        annotation.setValue((Type)new StringType("The patient's skin is dry"));
        annotations.add(annotation);
        return annotations;
    }
}

