/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;

public class AdjustBundleIdentifiers {
    private static final Gson gson = new Gson();
    private static final Pattern HAS_SCHEME = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+.-]*://.*");
    private static final Pattern LOOKS_HOST = Pattern.compile("^([A-Za-z0-9-]+\\.)+[A-Za-z]{2,}(/.*)?$");
    private static final Set<String> SYSTEM_KEYS = Set.of("system");
    private static final Set<String> URL_KEYS = Set.of("url");

    private static boolean isAbsolute(String s) {
        return s != null && (HAS_SCHEME.matcher(s).matches() || s.startsWith("urn:"));
    }

    private static String httpsify(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        String val = s.trim();
        if (val.startsWith("www.")) {
            return "https://" + val;
        }
        if (!AdjustBundleIdentifiers.isAbsolute(val) && LOOKS_HOST.matcher(val).matches()) {
            return "https://" + val;
        }
        return val;
    }

    private static String normalizeSystem(String system) {
        if (system == null) {
            return null;
        }
        String s = system.trim();
        if ("https://www.xid.ch/id/ean".equals(s) || "www.xid.ch/id/ean".equals(s)) {
            return "urn:oid:2.51.1.3";
        }
        if ("https://www.ahv.ch/xid".equals(s) || "www.ahv.ch/xid".equals(s)) {
            return "urn:oid:2.16.756.5.32";
        }
        return AdjustBundleIdentifiers.httpsify(s);
    }

    public static String adjustBundleJsonString(String bundleJsonString) {
        JsonObject bundleJson = JsonParser.parseString((String)bundleJsonString).getAsJsonObject();
        AdjustBundleIdentifiers.adjustJsonObject(bundleJson);
        return gson.toJson((JsonElement)bundleJson);
    }

    private static void adjustJsonObject(JsonObject obj) {
        for (Map.Entry e : obj.entrySet()) {
            String key = (String)e.getKey();
            JsonElement val = (JsonElement)e.getValue();
            if (val.isJsonObject()) {
                JsonObject child = val.getAsJsonObject();
                AdjustBundleIdentifiers.adjustJsonObject(child);
                if (!"extension".equals(key) || !child.has("url") || !child.get("url").isJsonPrimitive()) continue;
                String url = child.get("url").getAsString();
                child.addProperty("url", AdjustBundleIdentifiers.httpsify(url));
                continue;
            }
            if (val.isJsonArray()) {
                AdjustBundleIdentifiers.adjustJsonArray(val.getAsJsonArray(), key);
                continue;
            }
            if (!val.isJsonPrimitive() || !val.getAsJsonPrimitive().isString()) continue;
            String s = val.getAsString();
            String trimmed = s.replaceAll("\\s+$", "");
            if (AdjustBundleIdentifiers.isSystemKey(key)) {
                obj.addProperty(key, AdjustBundleIdentifiers.normalizeSystem(trimmed));
                continue;
            }
            if (AdjustBundleIdentifiers.isUrlKey(key)) {
                obj.addProperty(key, AdjustBundleIdentifiers.httpsify(trimmed));
                continue;
            }
            obj.addProperty(key, trimmed);
        }
    }

    private static boolean isSystemKey(String key) {
        return SYSTEM_KEYS.contains(key);
    }

    private static boolean isUrlKey(String key) {
        return URL_KEYS.contains(key);
    }

    private static void adjustJsonArray(JsonArray arr, String parentKey) {
        int i = 0;
        while (i < arr.size()) {
            JsonElement el = arr.get(i);
            if (el.isJsonObject()) {
                JsonObject child = el.getAsJsonObject();
                if ("extension".equals(parentKey) && child.has("url") && child.get("url").isJsonPrimitive()) {
                    child.addProperty("url", AdjustBundleIdentifiers.httpsify(child.get("url").getAsString()));
                }
                if (child.has("system") && child.get("system").isJsonPrimitive()) {
                    child.addProperty("system", AdjustBundleIdentifiers.normalizeSystem(child.get("system").getAsString()));
                }
                AdjustBundleIdentifiers.adjustJsonObject(child);
            } else if (el.isJsonArray()) {
                AdjustBundleIdentifiers.adjustJsonArray(el.getAsJsonArray(), parentKey);
            } else if (el.isJsonPrimitive() && el.getAsJsonPrimitive().isString()) {
                String adjustedValue = el.getAsString().replaceAll("\\s+$", "");
                arr.set(i, (JsonElement)new JsonPrimitive(adjustedValue));
            }
            ++i;
        }
    }

    public static void adjustBundleIdentifiers(Bundle bundle) {
        for (Bundle.BundleEntryComponent entry : bundle.getEntry()) {
            Resource resource = entry.getResource();
            if (resource instanceof Patient) {
                AdjustBundleIdentifiers.adjustPatientIdentifiers((Patient)resource);
                continue;
            }
            if (resource instanceof Organization) {
                AdjustBundleIdentifiers.adjustOrganizationIdentifiers((Organization)resource);
                continue;
            }
            if (resource instanceof Coverage) {
                AdjustBundleIdentifiers.adjustCoverageIdentifiers((Coverage)resource);
                continue;
            }
            if (resource instanceof Medication) {
                AdjustBundleIdentifiers.removeMedicationExtensions((Medication)resource);
                continue;
            }
            if (resource instanceof Practitioner) {
                AdjustBundleIdentifiers.adjustPractitioner((Practitioner)resource);
                continue;
            }
            if (resource instanceof PractitionerRole) {
                AdjustBundleIdentifiers.adjustPractitionerRole((PractitionerRole)resource);
                continue;
            }
            if (resource instanceof AllergyIntolerance) {
                AdjustBundleIdentifiers.adjustAllergyIntolerance((AllergyIntolerance)resource);
                continue;
            }
            if (resource instanceof FamilyMemberHistory) {
                AdjustBundleIdentifiers.adjustFamilyMemberHistory((FamilyMemberHistory)resource);
                continue;
            }
            if (!(resource instanceof MedicationStatement)) continue;
            AdjustBundleIdentifiers.adjustMedicationStatement((MedicationStatement)resource);
        }
    }

    private static void adjustPractitioner(Practitioner practitioner) {
        practitioner.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-practitioner");
        practitioner.getIdentifier().forEach(id -> {
            if (id.hasSystem()) {
                id.setSystem(AdjustBundleIdentifiers.normalizeSystem(id.getSystem()));
            }
        });
        practitioner.getQualification().forEach(q -> q.getCode().getCoding().forEach(cd -> {
            Coding coding = cd.setSystem(AdjustBundleIdentifiers.normalizeSystem(cd.getSystem()));
        }));
    }

    private static void adjustPractitionerRole(PractitionerRole pr) {
        pr.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-practitionerRole");
        pr.getCode().forEach(cc -> cc.getCoding().forEach(cd -> {
            if (cd.hasSystem() && cd.getSystem().startsWith("www.")) {
                cd.setSystem("https://" + cd.getSystem());
            }
        }));
        ArrayList<CodeableConcept> cleaned = new ArrayList<CodeableConcept>();
        for (CodeableConcept cc2 : pr.getCode()) {
            CodeableConcept kept = new CodeableConcept();
            if (cc2.hasText()) {
                kept.setText(cc2.getText());
            }
            for (Coding cd : cc2.getCoding()) {
                String sys = cd.getSystem();
                if ("https://www.elexis.info/practitioner/role".equals(sys)) continue;
                kept.addCoding(cd);
            }
            if (kept.getCoding().isEmpty() && !kept.hasText()) continue;
            cleaned.add(kept);
        }
        pr.setCode(cleaned);
        if (!pr.hasCode() || pr.getCodeFirstRep().getCoding().isEmpty()) {
            pr.setCode(List.of(new CodeableConcept().addCoding(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/practitioner-role").setCode("doctor").setDisplay("Doctor"))));
        }
    }

    private static void adjustAllergyIntolerance(AllergyIntolerance ai) {
        ai.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-allergyIntolerance");
        if (!ai.hasClinicalStatus()) {
            ai.setClinicalStatus(new CodeableConcept().addCoding(new Coding("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "active", "Active")));
        }
        if (!ai.hasVerificationStatus()) {
            ai.setVerificationStatus(new CodeableConcept().addCoding(new Coding("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "confirmed", "Confirmed")));
        }
        if (ai.hasCode() && ai.getCode().hasText()) {
            ai.getCode().setText(ai.getCode().getText().trim());
        }
    }

    private static void adjustMedicationStatement(MedicationStatement ms) {
        Period p;
        ms.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-medicationStatement");
        if (ms.hasEffectivePeriod() && !(p = ms.getEffectivePeriod()).hasEnd()) {
            ms.setEffective((Type)new DateTimeType(p.hasStart() ? p.getStart() : new Date()));
        }
        ms.getReasonCode().forEach(cc -> cc.getCoding().forEach(cd -> {
            Coding coding = cd.setSystem(AdjustBundleIdentifiers.normalizeSystem(cd.getSystem()));
        }));
    }

    private static void adjustFamilyMemberHistory(FamilyMemberHistory fmh) {
        fmh.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-familyMemberHistory");
        if (!fmh.hasStatus()) {
            fmh.setStatus(FamilyMemberHistory.FamilyHistoryStatus.COMPLETED);
        }
        if (!fmh.hasRelationship()) {
            fmh.setRelationship(new CodeableConcept().addCoding(new Coding("http://terminology.hl7.org/CodeSystem/v3-RoleCode", "FAMMEMB", "family member")));
        }
        if (!fmh.hasCondition()) {
            FamilyMemberHistory.FamilyMemberHistoryConditionComponent cond = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
            cond.setCode(new CodeableConcept().setText("unknown condition"));
            fmh.addCondition(cond);
        }
        if (!fmh.hasText() || !fmh.getText().hasDiv()) {
            fmh.getText().setStatus(Narrative.NarrativeStatus.GENERATED).setDivAsString("<div xmlns=\"http://www.w3.org/1999/xhtml\">Family history</div>");
        }
    }

    private static void removeMedicationExtensions(Medication medication) {
        if (medication.hasExtension()) {
            medication.setExtension(null);
        }
        medication.getCode().getCoding().forEach(cd -> {
            Coding coding = cd.setSystem(AdjustBundleIdentifiers.normalizeSystem(cd.getSystem()));
        });
    }

    private static void adjustPatientIdentifiers(Patient patient) {
        for (Identifier identifier : patient.getIdentifier()) {
            identifier.setSystem(AdjustBundleIdentifiers.normalizeSystem(identifier.getSystem()));
            if ("urn:oid:2.16.756.5.32".equals(identifier.getSystem())) {
                identifier.setSystem("urn:oid:2.16.756.5.32");
            }
            if (!"https://www.elexis.info/patnr".equals(identifier.getSystem())) continue;
            CodeableConcept type = new CodeableConcept();
            type.addCoding(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/v2-0203").setCode("MR").setDisplay("Medical record number"));
            identifier.setType(type);
        }
        if (patient.hasExtension()) {
            patient.setExtension(null);
        }
        if (patient.hasMaritalStatus() && patient.getMaritalStatus().hasCoding()) {
            for (Coding coding : patient.getMaritalStatus().getCoding()) {
                if (coding.getSystem() == null || coding.getSystem().isEmpty()) {
                    coding.setSystem("http://terminology.hl7.org/CodeSystem/v3-MaritalStatus");
                }
                if (!"UNK".equals(coding.getCode())) continue;
                coding.setCode("U");
                coding.setDisplay("unmarried");
            }
        }
    }

    private static void adjustOrganizationIdentifiers(Organization organization) {
        for (Identifier identifier : organization.getIdentifier()) {
            identifier.setSystem(AdjustBundleIdentifiers.normalizeSystem(identifier.getSystem()));
            if (!"urn:oid:2.51.1.3".equals(identifier.getSystem())) continue;
            identifier.setSystem("urn:oid:2.51.1.3");
        }
        if (organization.hasAddress()) {
            for (Address address : organization.getAddress()) {
                if (!"home".equalsIgnoreCase(address.getUse().toString())) continue;
                address.setUse(Address.AddressUse.WORK);
            }
        }
    }

    private static void adjustCoverageIdentifiers(Coverage coverage) {
        CodeableConcept type;
        String newValue = null;
        for (Identifier identifier : coverage.getIdentifier()) {
            identifier.setSystem(AdjustBundleIdentifiers.normalizeSystem(identifier.getSystem()));
        }
        if (coverage.hasType() && (type = coverage.getType()).hasCoding()) {
            ArrayList<Coding> keep = new ArrayList<Coding>();
            for (Coding cd : type.getCoding()) {
                String sys = AdjustBundleIdentifiers.normalizeSystem(cd.getSystem());
                if ("https://www.elexis.info/coverage/reason".equals(sys)) continue;
                if ("https://www.elexis.info/coverage/type".equals(sys) || "www.elexis.info/coverage/type".equals(sys)) {
                    sys = "http://fhir.ch/ig/ch-orf/CodeSystem/ch-orf-cs-coveragetype";
                }
                cd.setSystem(sys);
                if (!cd.hasDisplay() && cd.hasCode()) {
                    cd.setDisplay(AdjustBundleIdentifiers.getCoverageDisplay(cd.getCode()));
                }
                keep.add(cd);
            }
            type.setCoding(keep);
        }
        for (Identifier identifier : coverage.getIdentifier()) {
            if (!"urn:oid:2.16.756.5.30.1.123.100.1.1.1".equals(identifier.getSystem())) continue;
            newValue = identifier.getValue();
            break;
        }
        for (Identifier identifier : coverage.getIdentifier()) {
            if (!"https://www.elexis.info/objid".equals(identifier.getSystem()) || newValue == null) continue;
            identifier.setValue(newValue);
        }
        if (coverage.hasDependent()) {
            coverage.setDependent(null);
        }
        if (coverage.hasText()) {
            coverage.setText(null);
        }
        coverage.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-coverage");
    }

    public static String getCoverageDisplay(String code) {
        if (code == null) {
            return "Other";
        }
        return switch (code) {
            case "KVG" -> "According to KVG";
            case "UVG" -> "According to UVG";
            case "VVG" -> "According to VVG";
            case "IVG" -> "According to IVG";
            case "MVG" -> "According to MVG";
            case "Self" -> "Self";
            case "Other" -> "Other";
            default -> "Other";
        };
    }
}

