/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IRelatedContact;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.mednet.webapi.core.fhir.resources.AllergyIntoleranceResource;
import ch.elexis.mednet.webapi.core.fhir.resources.AnnotationResource;
import ch.elexis.mednet.webapi.core.fhir.resources.CompositionResource;
import ch.elexis.mednet.webapi.core.fhir.resources.ConditionResource;
import ch.elexis.mednet.webapi.core.fhir.resources.CoverageResource;
import ch.elexis.mednet.webapi.core.fhir.resources.DeviceResource;
import ch.elexis.mednet.webapi.core.fhir.resources.DocumentResource;
import ch.elexis.mednet.webapi.core.fhir.resources.FamilyMemberHistoryResource;
import ch.elexis.mednet.webapi.core.fhir.resources.MedicationStatementResource;
import ch.elexis.mednet.webapi.core.fhir.resources.ObservationResource;
import ch.elexis.mednet.webapi.core.fhir.resources.OrganizationResource;
import ch.elexis.mednet.webapi.core.fhir.resources.PractitionerResource;
import ch.elexis.mednet.webapi.core.fhir.resources.PractitionerRoleResource;
import ch.elexis.mednet.webapi.core.fhir.resources.ProcedureResource;
import ch.elexis.mednet.webapi.core.fhir.resources.RiskFactorResource;
import ch.elexis.mednet.webapi.core.fhir.resources.util.AdjustBundleIdentifiers;
import ch.elexis.mednet.webapi.core.fhir.resources.util.FhirResourceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;

public class BundleResource {
    private static Map<String, String> idToFullUrl;

    public static Bundle createPatientOverviewBundle(Patient patient, IPatient sourcePatient, List<IDocument> selectedDocuments, boolean isEpdSelected, FhirResourceFactory resourceFactory, IModelService coreModelService, IFindingsService findingsService) {
        String msFullUrl;
        IContact coveragePayor;
        ICoverage encounterCoverage;
        Practitioner gpPractitioner;
        Optional gpMandatorOptional;
        IPerson generalPractitionerMandator;
        idToFullUrl = new HashMap<String, String>();
        Bundle bundle = new Bundle();
        bundle.setType(Bundle.BundleType.DOCUMENT);
        String bundleId = UUID.randomUUID().toString();
        bundle.setId(bundleId);
        bundle.getIdentifier().setSystem("urn:ietf:rfc:3986").setValue("urn:uuid:" + bundleId);
        bundle.setTimestamp(new Date());
        ArrayList<Bundle.BundleEntryComponent> bundleEntries = new ArrayList<Bundle.BundleEntryComponent>();
        Composition composition = CompositionResource.createComposition(patient);
        BundleResource.addEntryAndIndex(bundleEntries, (Resource)composition);
        String patientFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)patient);
        composition.setSubject(new Reference(patientFullUrl));
        List relatedContacts = sourcePatient.getRelatedContacts();
        for (IRelatedContact relatedContact : relatedContacts) {
            IContact otherContact = relatedContact.getOtherContact();
            if (otherContact == null || !otherContact.isOrganization()) continue;
            Organization organization = OrganizationResource.createOrganization(otherContact, resourceFactory);
            BundleResource.addEntryAndIndex(bundleEntries, (Resource)organization);
        }
        String gpId = (String)sourcePatient.getExtInfo((Object)"Stammarzt_");
        if (gpId != null && !gpId.isEmpty() && (generalPractitionerMandator = (IPerson)(gpMandatorOptional = coreModelService.load(gpId, IPerson.class)).orElse(null)) != null && (gpPractitioner = resourceFactory.getResource(generalPractitionerMandator, IPerson.class, Practitioner.class)) != null) {
            gpPractitioner = PractitionerResource.adjustPractitioner(gpPractitioner);
            BundleResource.addEntryAndIndex(bundleEntries, (Resource)gpPractitioner);
            Optional<IUser> gpUserOptional = BundleResource.findMandatorUser(gpMandatorOptional);
            if (gpUserOptional.isPresent()) {
                IUser gpUser = gpUserOptional.get();
                PractitionerRole gpPractitionerRole = new PractitionerRoleResource().createPractitionerRole(gpUser, gpPractitioner, resourceFactory);
                String gpPractitionerRoleFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)gpPractitionerRole);
                patient.addGeneralPractitioner(new Reference(gpPractitionerRoleFullUrl));
            }
        }
        Device device = DeviceResource.createDevice();
        String deviceFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)device);
        composition.addAuthor(new Reference(deviceFullUrl));
        List<AllergyIntolerance> allergies = AllergyIntoleranceResource.createAllergies(patient, sourcePatient, resourceFactory);
        ArrayList<Reference> allergyReferences = new ArrayList<Reference>();
        for (AllergyIntolerance allergy : allergies) {
            allergy.setPatient(new Reference(patientFullUrl));
            String allergyFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)allergy);
            allergyReferences.add(new Reference(allergyFullUrl));
        }
        Composition.SectionComponent allergySection = new Composition.SectionComponent();
        allergySection.setTitle("Allergies section");
        allergySection.setCode(new CodeableConcept().addCoding(new Coding("http://loinc.org", "48765-2", "Allergies and adverse reactions Document")));
        allergySection.setEntry(allergyReferences);
        composition.addSection(allergySection);
        Optional encounterOpt = ContextServiceHolder.get().getTyped(IEncounter.class);
        if (encounterOpt.isPresent() && (encounterCoverage = ((IEncounter)encounterOpt.get()).getCoverage()) != null && encounterCoverage.isOpen() && (coveragePayor = encounterCoverage.getCostBearer()) != null && coveragePayor.isOrganization()) {
            Coverage coverage = resourceFactory.getResource(encounterCoverage, ICoverage.class, Coverage.class);
            CoverageResource.toMednet(coverage, patientFullUrl);
            BillingLaw law = encounterCoverage.getBillingSystem().getLaw();
            String lawCode = BundleResource.mapLawToCode(law);
            coverage.setType(new CodeableConcept().addCoding(new Coding().setSystem("http://fhir.ch/ig/ch-orf/CodeSystem/ch-orf-cs-coveragetype").setCode(lawCode).setDisplay(AdjustBundleIdentifiers.getCoverageDisplay(lawCode))));
            String coverageFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)coverage);
            Organization organization = OrganizationResource.createOrganization(coveragePayor, resourceFactory);
            String orgFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)organization);
            coverage.setPayor(List.of(new Reference(orgFullUrl)));
            Composition.SectionComponent coverageSection = new Composition.SectionComponent();
            coverageSection.setTitle("Insurance data section");
            coverageSection.setCode(new CodeableConcept().addCoding(new Coding("http://loinc.org", "76437-3", "Primary insurance")));
            coverageSection.addEntry(new Reference(coverageFullUrl));
            composition.addSection(coverageSection);
        }
        boolean strukturDiagnose = ConfigServiceHolder.getGlobal((String)"diagnose/settings/useStructured", (boolean)false);
        List<ICondition> localConditions = ConditionResource.getLocalConditions(sourcePatient);
        ArrayList<Reference> conditionReferences = new ArrayList<Reference>();
        if (strukturDiagnose) {
            for (ICondition localCondition : localConditions) {
                Condition condition = resourceFactory.getResource(localCondition, ICondition.class, Condition.class);
                if (condition == null || !condition.hasClinicalStatus() || !condition.hasCode()) {
                    condition = ConditionResource.createConditionFallback(localCondition, patient);
                }
                condition.setSubject(new Reference(patientFullUrl));
                condFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)condition);
                conditionReferences.add(new Reference(condFullUrl));
            }
        } else {
            List<Condition> conditions = ConditionResource.createConditions(patient, sourcePatient);
            for (Condition condition : conditions) {
                condFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)condition);
                conditionReferences.add(new Reference(condFullUrl));
            }
        }
        Composition.SectionComponent conditionSection = new Composition.SectionComponent();
        conditionSection.setTitle("Problems section");
        conditionSection.setCode(new CodeableConcept().addCoding(new Coding("http://loinc.org", "11450-4", "Problem list - Reported")));
        conditionSection.setEntry(conditionReferences);
        composition.addSection(conditionSection);
        List prescriptions = sourcePatient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION));
        MedicationStatementResource medicationStatementResource = new MedicationStatementResource();
        ArrayList medications = new ArrayList();
        List<MedicationStatement> medicationStatements = medicationStatementResource.createMedicationStatementsFromPrescriptions(new Reference(patientFullUrl), prescriptions, resourceFactory);
        ArrayList<Reference> medicationReferences = new ArrayList<Reference>();
        for (MedicationStatement ms : medicationStatements) {
            ms.setSubject(new Reference(patientFullUrl));
            msFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)ms);
            medicationReferences.add(new Reference(msFullUrl));
        }
        for (Medication medication : medications) {
            msFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)medication);
        }
        Composition.SectionComponent medicationSection = new Composition.SectionComponent();
        medicationSection.setTitle("Medication Summary section");
        medicationSection.setCode(new CodeableConcept().addCoding(new Coding("http://loinc.org", "10160-0", "History of Medication use Narrative")));
        medicationSection.setEntry(medicationReferences);
        composition.addSection(medicationSection);
        List<Procedure> procedures = ProcedureResource.createProcedures(new Reference(patientFullUrl), sourcePatient, resourceFactory);
        ArrayList<Reference> procedureReferences = new ArrayList<Reference>();
        for (Procedure proc : procedures) {
            proc.setSubject(new Reference(patientFullUrl));
            String procFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)proc);
            procedureReferences.add(new Reference(procFullUrl));
        }
        Composition.SectionComponent procedureSection = new Composition.SectionComponent();
        procedureSection.setTitle("Procedures section");
        procedureSection.setCode(new CodeableConcept().addCoding(new Coding("http://loinc.org", "47519-4", "History of Procedures Document")));
        procedureSection.setEntry(procedureReferences);
        composition.addSection(procedureSection);
        List<Observation> observations = ObservationResource.createObservations(new Reference(patientFullUrl), resourceFactory, findingsService);
        ArrayList<Reference> observationReferences = new ArrayList<Reference>();
        for (Observation observation : observations) {
            observation.setSubject(new Reference(patientFullUrl));
            String obsFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)observation);
            observationReferences.add(new Reference(obsFullUrl));
        }
        if (!observationReferences.isEmpty()) {
            Composition.SectionComponent resultsSection = new Composition.SectionComponent();
            resultsSection.setTitle("Results section");
            resultsSection.setCode(new CodeableConcept().addCoding(new Coding("http://loinc.org", "30954-2", "Relevant diagnostic tests/laboratory data Narrative")));
            resultsSection.setEntry(observationReferences);
            composition.addSection(resultsSection);
        }
        List<Observation> riskFactors = RiskFactorResource.createRiskFactors(new Reference(patientFullUrl), sourcePatient, resourceFactory);
        ArrayList<Reference> riskFactorReferences = new ArrayList<Reference>();
        for (Observation riskFactor : riskFactors) {
            riskFactor.setSubject(new Reference(patientFullUrl));
            String rfFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)riskFactor);
            riskFactorReferences.add(new Reference(rfFullUrl));
        }
        List<FamilyMemberHistory> familyHistories = FamilyMemberHistoryResource.createFamilyMemberHistories(new Reference(patientFullUrl), sourcePatient, findingsService, resourceFactory);
        ArrayList<Reference> familyHistoryReferences = new ArrayList<Reference>();
        for (FamilyMemberHistory familyHistory : familyHistories) {
            String fmhFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)familyHistory);
            familyHistoryReferences.add(new Reference(fmhFullUrl));
        }
        Composition.SectionComponent socialHistorySection = new Composition.SectionComponent();
        socialHistorySection.setTitle("Social history section");
        socialHistorySection.setCode(new CodeableConcept().addCoding(new Coding("http://loinc.org", "29762-2", "Social history note")));
        socialHistorySection.setEntry(riskFactorReferences);
        socialHistorySection.getEntry().addAll(familyHistoryReferences);
        composition.addSection(socialHistorySection);
        List<Observation> annotations = AnnotationResource.createAnnotations(new Reference(patientFullUrl));
        ArrayList<Reference> annotationReferences = new ArrayList<Reference>();
        for (Observation annotation : annotations) {
            annotation.setSubject(new Reference(patientFullUrl));
            String annFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)annotation);
            annotationReferences.add(new Reference(annFullUrl));
        }
        Composition.SectionComponent annotationsSection = new Composition.SectionComponent();
        annotationsSection.setTitle("Comment");
        annotationsSection.setCode(new CodeableConcept().addCoding(new Coding("http://loinc.org", "48767-8", "Annotation comment [Interpretation] Narrative")));
        annotationsSection.setEntry(annotationReferences);
        composition.addSection(annotationsSection);
        if (selectedDocuments != null) {
            List<DocumentReference> documents = DocumentResource.createDocuments(sourcePatient, patientFullUrl, selectedDocuments, isEpdSelected);
            ArrayList<Reference> documentReferences = new ArrayList<Reference>();
            for (DocumentReference document : documents) {
                if (!document.hasSubject()) {
                    document.setSubject(new Reference(patientFullUrl));
                }
                String drFullUrl = BundleResource.addEntryAndIndex(bundleEntries, (Resource)document);
                documentReferences.add(new Reference(drFullUrl));
            }
            Composition.SectionComponent documentsSection = new Composition.SectionComponent();
            documentsSection.setTitle("Documents section");
            documentsSection.setCode(new CodeableConcept().addCoding(new Coding("http://loinc.org", "51899-3", "Details Document")));
            documentsSection.setEntry(documentReferences);
            composition.addSection(documentsSection);
        }
        bundle.setEntry(bundleEntries);
        for (Bundle.BundleEntryComponent e : bundleEntries) {
            Resource r = e.getResource();
            if (r instanceof MedicationStatement) {
                String idPart;
                int s;
                Reference inf;
                String v;
                MedicationStatement ms = (MedicationStatement)r;
                BundleResource.fixRelativeReference(ms.getSubject());
                BundleResource.fixRelativeReference(ms.getInformationSource());
                if (ms.hasMedicationReference()) {
                    BundleResource.fixRelativeReference(ms.getMedicationReference());
                }
                if (!ms.hasInformationSource() || (v = (inf = ms.getInformationSource()).getReference()) == null || v.startsWith("urn:uuid:") || v.startsWith("#") || (s = v.indexOf(47)) <= 0 || s >= v.length() - 1 || idToFullUrl.containsKey(idPart = v.substring(s + 1))) continue;
                ms.setInformationSource(null);
                continue;
            }
            if (r instanceof Condition) {
                Condition c = (Condition)r;
                BundleResource.fixRelativeReference(c.getSubject());
                BundleResource.fixRelativeReference(c.getAsserter());
                continue;
            }
            if (r instanceof Procedure) {
                Procedure p2 = (Procedure)r;
                BundleResource.fixRelativeReference(p2.getSubject());
                if (!p2.hasPerformer()) continue;
                p2.getPerformer().forEach(perf -> BundleResource.fixRelativeReference(perf.getActor()));
                continue;
            }
            if (r instanceof Observation) {
                Observation o = (Observation)r;
                BundleResource.fixRelativeReference(o.getSubject());
                if (!o.hasPerformer()) continue;
                o.getPerformer().forEach(thisRef -> BundleResource.fixRelativeReference(thisRef));
                continue;
            }
            if (r instanceof FamilyMemberHistory) {
                FamilyMemberHistory fmh = (FamilyMemberHistory)r;
                BundleResource.fixRelativeReference(fmh.getPatient());
                continue;
            }
            if (r instanceof DocumentReference) {
                DocumentReference dr = (DocumentReference)r;
                BundleResource.fixRelativeReference(dr.getSubject());
                if (dr.hasAuthor()) {
                    dr.getAuthor().forEach(a -> BundleResource.fixRelativeReference(a));
                }
                BundleResource.fixRelativeReference(dr.getCustodian());
                continue;
            }
            if (r instanceof PractitionerRole) {
                PractitionerRole pr = (PractitionerRole)r;
                BundleResource.fixRelativeReference(pr.getPractitioner());
                BundleResource.fixRelativeReference(pr.getOrganization());
                continue;
            }
            if (r instanceof Coverage) {
                Coverage cov = (Coverage)r;
                BundleResource.fixRelativeReference(cov.getBeneficiary());
                BundleResource.fixRelativeReference(cov.getPolicyHolder());
                if (!cov.hasPayor()) continue;
                cov.getPayor().forEach(p -> BundleResource.fixRelativeReference(p));
                continue;
            }
            if (!(r instanceof Composition)) continue;
            Composition comp = (Composition)r;
            BundleResource.fixRelativeReference(comp.getSubject());
            if (!comp.hasAuthor()) continue;
            comp.getAuthor().forEach(a -> BundleResource.fixRelativeReference(a));
        }
        return bundle;
    }

    private static Optional<IUser> findMandatorUser(Optional<IPerson> mandator) {
        if (mandator.isEmpty()) {
            return Optional.empty();
        }
        IQuery userQuery = CoreModelServiceHolder.get().getQuery(IUser.class);
        userQuery.and((EStructuralFeature)ModelPackage.Literals.IUSER__ASSIGNED_CONTACT, IQuery.COMPARATOR.NOT_EQUALS, null);
        return userQuery.execute().stream().filter(u -> u.getAssignedContact() != null && u.getAssignedContact().getId().equals(((IPerson)mandator.get()).getId())).findFirst();
    }

    private static String addEntryAndIndex(List<Bundle.BundleEntryComponent> entries, Resource r) {
        String fullUrl = BundleResource.normalizeIdAndGetFullUrl(r);
        Bundle.BundleEntryComponent e = new Bundle.BundleEntryComponent();
        e.setFullUrl(fullUrl);
        e.setResource(r);
        entries.add(e);
        idToFullUrl.put(r.getIdElement().getIdPart(), fullUrl);
        return fullUrl;
    }

    private static String normalizeIdAndGetFullUrl(Resource r) {
        String idPart = r.getIdElement() != null ? r.getIdElement().getIdPart() : null;
        String uuid = idPart == null || idPart.isBlank() ? UUID.randomUUID().toString() : UUID.nameUUIDFromBytes(idPart.getBytes()).toString();
        r.setId(uuid);
        return "urn:uuid:" + uuid;
    }

    private static void fixRelativeReference(Reference ref) {
        String idPart;
        String mapped;
        if (ref == null || !ref.hasReference()) {
            return;
        }
        String val = ref.getReference();
        if (val == null || val.startsWith("urn:uuid:") || val.startsWith("#")) {
            return;
        }
        int slash = val.indexOf(47);
        if (slash > 0 && slash < val.length() - 1 && (mapped = idToFullUrl.get(idPart = val.substring(slash + 1))) != null) {
            ref.setReference(mapped);
        }
    }

    private static String mapLawToCode(BillingLaw law) {
        if (law == null) {
            return "Other";
        }
        return switch (law) {
            case BillingLaw.KVG -> "KVG";
            case BillingLaw.UVG -> "UVG";
            case BillingLaw.IV -> "IVG";
            case BillingLaw.MV -> "MVG";
            case BillingLaw.VVG -> "VVG";
            case BillingLaw.privat -> "Self";
            case BillingLaw.ORG, BillingLaw.NONE -> "Other";
            case BillingLaw.OTHER -> "Other";
            default -> throw new MatchException(null, null);
        };
    }
}

