/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.util.FindingsServiceHolder;
import ch.elexis.mednet.webapi.core.fhir.resources.util.FhirResourceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Reference;

public class ObservationResource {
    public static List<Observation> createObservations(Reference patientReference, FhirResourceFactory resourceFactory, IFindingsService findingsService) {
        ArrayList<Observation> observations = new ArrayList<Observation>();
        String patientIdPart = patientReference.getReferenceElement().getIdPart();
        List localObservations = FindingsServiceHolder.getiFindingsService().getPatientsFindings(patientIdPart, IObservation.class);
        for (IObservation local : localObservations) {
            Observation obs = resourceFactory.getResource(local, IObservation.class, Observation.class);
            if (obs == null) {
                obs = new Observation();
                obs.setId(UUID.randomUUID().toString());
            }
            if (!obs.hasId() || obs.getIdElement().getIdPart() == null || obs.getIdElement().getIdPart().isBlank()) {
                obs.setId(UUID.randomUUID().toString());
            }
            obs.setSubject(new Reference(patientReference.getReference()));
            if (!obs.hasStatus()) {
                obs.setStatus(Observation.ObservationStatus.FINAL);
            }
            if (obs.getCategory() == null || obs.getCategory().isEmpty()) {
                obs.addCategory(new CodeableConcept().addCoding(new Coding("http://terminology.hl7.org/CodeSystem/observation-category", "laboratory", "Laboratory")));
            }
            if (!obs.hasCode() || obs.getCode().getCoding().isEmpty()) {
                CodeableConcept cc = new CodeableConcept();
                Optional maybeText = local.getText();
                if (maybeText.isPresent() && !((String)maybeText.get()).isBlank()) {
                    cc.setText(((String)maybeText.get()).trim());
                } else {
                    cc.setText("Observation");
                }
                obs.setCode(cc);
            }
            observations.add(obs);
        }
        return observations;
    }
}

