/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labororder.lg1_medicalvalues.order;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.labororder.lg1_medicalvalues.messages.Messages;
import ch.elexis.labororder.lg1_medicalvalues.order.model.Patient;
import ch.elexis.labororder.lg1_medicalvalues.order.model.exceptions.NoEncounterSelectedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.NoSuchElementException;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.LoggerFactory;

public class LabOrderAction
extends Action {
    public LabOrderAction() {
        this.setId("ch.elexis.laborder.lg1_medicalvalues.laborder");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.labororder.lg1_medicalvalues", (String)"rsc/lg1_logo.png"));
        this.setText(Messages.LaborOrderAction_LG1NameAction);
    }

    public void run() {
        try {
            IPatient patient = (IPatient)ContextServiceHolder.get().getActivePatient().get();
            URL url = this.buildOrderCreationUrl(patient);
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
        }
        catch (NoSuchElementException e) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Es ist kein Patient ausgew\u00e4hlt.");
        }
        catch (NoEncounterSelectedException e) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabOrderAction_errorTitleNoFallSelected, (String)Messages.LabOrderAction_errorMessageNoFallSelected);
        }
        catch (MalformedURLException | URISyntaxException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error building medicalvalues order creation API URL", (Throwable)e);
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist ein Fehler beim Erstellen der URL f\u00fcr die Auftragserstellung aufgetreten.\n\n" + e.getLocalizedMessage()));
        }
        catch (IOException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error contacting LG1 web service", (Throwable)e);
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist ein Fehler beim LG1 Aufruf aufgetreten.\n\n" + e.getLocalizedMessage()));
        }
        catch (PartInitException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error opening browser with medicalvalues order creation API URL", (Throwable)e);
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist ein Fehler beim \u00d6ffnen des Browsers aufgetreten.\n\n" + e.getLocalizedMessage()));
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error calling medicalvalues order creation API", (Throwable)e);
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es fehlen zur Auftragserstellung ben\u00f6tigte Patientendaten.\n\n" + e.getLocalizedMessage()));
        }
    }

    private URL buildOrderCreationUrl(IPatient patient) throws URISyntaxException, MalformedURLException, NoEncounterSelectedException {
        URIBuilder builder = new URIBuilder("https://oe.lg1.ch/de/diagnostic-intelligence/orders/importPatientAndCreateOrder");
        Patient lg1Patient = Patient.of(patient);
        lg1Patient.toMedicalvaluesOrderCreationAPIQueryParams(builder);
        return builder.build().toURL();
    }
}

