/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labororder.lg1.order;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.labororder.lg1.messages.Messages;
import ch.elexis.labororder.lg1.order.ResponseDialog;
import ch.elexis.labororder.lg1.order.model.Patient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.LoggerFactory;

public class LabOrderAction
extends Action {
    private Gson gson;
    private String appkey;

    public LabOrderAction() {
        this.setId("ch.elexis.laborder.lg1.laborder");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.labororder.lg1", (String)"rsc/lg1_logo.png"));
        this.setText(Messages.LabOrderAction_nameAction);
    }

    public void run() {
        ch.elexis.data.Patient patient = ElexisEventDispatcher.getSelectedPatient();
        if (patient != null) {
            try {
                this.sendPostRequest(patient);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error contacting LG1 web service", (Throwable)e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist ein Fehler beim LG1 Aufruf aufgetreten.\n\n" + e.getLocalizedMessage()));
            }
        }
    }

    private void sendPostRequest(ch.elexis.data.Patient patient) throws IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost("https://ms2.medapp.ch/rest/lg1/v1/call-medapp/");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
        params.add(new BasicNameValuePair("appkey", this.getAppkey()));
        params.add(new BasicNameValuePair("service", "orderentry"));
        params.add(new BasicNameValuePair("data", this.getData(patient)));
        httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Got response code [" + response.getStatusLine().getStatusCode() + "] from [" + httppost.getURI().toString() + "]");
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream instream = entity.getContent();){
                String responseText = IOUtils.toString((InputStream)instream, (String)"UTF-8");
                if (StringUtils.isNotBlank((CharSequence)responseText)) {
                    ResponseDialog dialog = new ResponseDialog(responseText, Display.getDefault().getActiveShell());
                    dialog.open();
                } else {
                    Header[] responseHeaders = response.getAllHeaders();
                    String location = "https://medapp.ch/";
                    Header[] headerArray = responseHeaders;
                    int n = responseHeaders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Header header = headerArray[n2];
                        if (header.getName().equalsIgnoreCase("location") && header.getValue().startsWith("http")) {
                            location = header.getValue();
                        }
                        ++n2;
                    }
                    ResponseDialog.openMedapp(location);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private String getAppkey() {
        if (this.appkey == null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream("/rsc/config");){
                    this.appkey = IOUtils.toString((InputStream)input, (String)"UTF-8");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error reading config");
                this.appkey = "noappkey";
            }
        }
        return this.appkey;
    }

    private String getData(ch.elexis.data.Patient patient) {
        if (this.gson == null) {
            this.gson = new GsonBuilder().disableHtmlEscaping().create();
        }
        Patient lg1Patient = Patient.of(patient);
        HashMap<String, Patient> map = new HashMap<String, Patient>();
        map.put("patient", lg1Patient);
        return this.gson.toJson(map);
    }
}

