/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.medics.v2.data;

import ch.elexis.core.data.util.PlatformHelper;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.labor.medics.v2.Messages;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KontaktOrderManagement
extends PersistentObject {
    public static final String TABLENAME = "KONTAKT_ORDER_MANAGEMENT";
    public static final String FLD_KONTAKT_ID = "KONTAKT_ID";
    public static final String FLD_ORDER_NR = "ORDER_NR";
    public static long FIRST_ORDER_NR;
    private static final JdbcLink j;
    protected static Logger log;

    static {
        block6: {
            FIRST_ORDER_NR = 100000L;
            j = KontaktOrderManagement.getConnection();
            log = LoggerFactory.getLogger((String)KontaktOrderManagement.class.getName());
            if (!KontaktOrderManagement.tableExists((String)TABLENAME)) {
                String filepath = PlatformHelper.getBasePath((String)"ch.elexis.laborimport.medics.v2") + File.separator + "createTable.script";
                JdbcLink.Stm stm = j.getStatement();
                try {
                    try {
                        FileInputStream fis = new FileInputStream(filepath);
                        stm.execScript((InputStream)fis, true, true);
                    }
                    catch (Exception e) {
                        ExHandler.handle((Throwable)e);
                        SWTHelper.showError((String)Messages.KontaktOrderManagement_titleErrorCreateDB, (String)MessageFormat.format(Messages.KontaktOrderManagement_messageErrorCreateDB, filepath));
                        j.releaseStatement(stm);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    j.releaseStatement(stm);
                    throw throwable;
                }
                j.releaseStatement(stm);
            }
        }
        KontaktOrderManagement.addMapping((String)TABLENAME, (String[])new String[]{FLD_KONTAKT_ID, FLD_ORDER_NR});
    }

    public KontaktOrderManagement() {
    }

    private KontaktOrderManagement(String id) {
        super(id);
    }

    public KontaktOrderManagement(Kontakt kontakt) {
        this.create(null);
        this.setKontakt(kontakt);
        this.setOrderNr(FIRST_ORDER_NR);
    }

    public static KontaktOrderManagement load(String id) {
        return new KontaktOrderManagement(id);
    }

    public Kontakt getKontakt() {
        return Kontakt.load((String)this.get(FLD_KONTAKT_ID));
    }

    public void setKontakt(Kontakt kontakt) {
        if (kontakt != null) {
            this.set(FLD_KONTAKT_ID, kontakt.getId());
        }
    }

    private static Long getLong(String longStr) {
        Long value = null;
        if (longStr != null && longStr.length() > 0) {
            try {
                value = Long.parseLong(longStr);
            }
            catch (NumberFormatException e) {
                log.warn(MessageFormat.format("Could not parse long {0}!", longStr), (Throwable)e);
            }
        }
        return value;
    }

    public Long getOrderNr() {
        String intStr = this.get(FLD_ORDER_NR);
        return KontaktOrderManagement.getLong(intStr);
    }

    public void setOrderNr(Long orderNr) {
        if (orderNr != null) {
            this.set(FLD_ORDER_NR, orderNr.toString());
        }
    }

    public String getLabel() {
        Kontakt kontakt = this.getKontakt();
        if (kontakt != null) {
            return kontakt.getLabel() + " (" + String.valueOf(this.getOrderNr()) + ")";
        }
        return "-";
    }

    protected String getTableName() {
        return TABLENAME;
    }
}

