/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.medics.v2;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.labor.medics.v2.MedicsPreferencePage;
import ch.elexis.labor.medics.v2.order.WebAis;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WebAisMandatorComposite
extends Composite {
    private IMandator mandator;
    private Button btnCredentials;
    private MedicsPreferencePage medicsPreferencePage;

    public WebAisMandatorComposite(IMandator mandator, MedicsPreferencePage medicsPreferencePage, Composite container, int style) {
        super(container, style);
        this.mandator = mandator;
        this.medicsPreferencePage = medicsPreferencePage;
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout());
        Label lab = new Label((Composite)this, 0);
        lab.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lab.setText(this.mandator.getLabel());
        this.btnCredentials = new Button((Composite)this, 8);
        this.btnCredentials.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialsDialog dialog = new CredentialsDialog(WebAisMandatorComposite.this.getShell());
                if (dialog.open() == 0) {
                    WebAisMandatorComposite.this.updateCredentials();
                }
            }
        });
        this.updateCredentials();
    }

    public void updateCredentials() {
        if (WebAis.hasCredentials(this.mandator)) {
            this.btnCredentials.setText("Anmelde Informationen \u00fcberschrieben");
        } else {
            this.btnCredentials.setText("Anmelde Informationen setzen");
        }
        this.layout();
    }

    private void setDefaultCredentialsConfig(String customer, String username, String password, String requester) {
        List mandators = CoreModelServiceHolder.get().getQuery(IMandator.class).execute();
        mandators.sort((l, r) -> l.getLabel().compareTo(r.getLabel()));
        mandators.forEach(m -> {
            if (!WebAis.hasCredentials(m)) {
                this.setCredentialsConfig((IMandator)m, customer, username, password, requester);
            }
        });
        this.medicsPreferencePage.updateMandatorComposites();
    }

    private void setCredentialsConfig(IMandator mandator, String customer, String username, String password, String requester) {
        ConfigServiceHolder.get().set((IContact)mandator, "Medics_LaborOrder/customer", customer);
        ConfigServiceHolder.get().set((IContact)mandator, "Medics_LaborOrder/username", username);
        ConfigServiceHolder.get().set((IContact)mandator, "Medics_LaborOrder/password", password);
        ConfigServiceHolder.get().set((IContact)mandator, "Medics_LaborOrder/requester", requester);
    }

    private class CredentialsDialog
    extends Dialog {
        private Text customerTxt;
        private Text usernameTxt;
        private Text passwordTxt;
        private Text requesterTxt;

        protected CredentialsDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = (Composite)super.createDialogArea(parent);
            this.customerTxt = new Text(ret, 2048);
            this.customerTxt.setMessage("Customer");
            this.customerTxt.setToolTipText("Customer");
            this.customerTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.usernameTxt = new Text(ret, 2048);
            this.usernameTxt.setMessage("Username");
            this.usernameTxt.setToolTipText("Username");
            this.usernameTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.passwordTxt = new Text(ret, 2048);
            this.passwordTxt.setMessage("Password");
            this.passwordTxt.setToolTipText("Password");
            this.passwordTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.requesterTxt = new Text(ret, 2048);
            this.requesterTxt.setMessage("Requester");
            this.requesterTxt.setToolTipText("Requester");
            this.requesterTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.loadFromConfig();
            Button clear = new Button(ret, 8);
            clear.setText("Leeren");
            clear.setToolTipText("Diese Konfiguration leeren.");
            clear.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WebAisMandatorComposite.this.setCredentialsConfig(((CredentialsDialog)CredentialsDialog.this).WebAisMandatorComposite.this.mandator, null, null, null, null);
                    CredentialsDialog.this.loadFromConfig();
                }
            });
            if (ContextServiceHolder.get().getActiveUser().isPresent() && ((IUser)ContextServiceHolder.get().getActiveUser().get()).isAdministrator()) {
                Button setAsDefault = new Button(ret, 8);
                setAsDefault.setText("Als std. \u00fcbernehmen");
                setAsDefault.setToolTipText("Als Standard bei allen Mandanten die noch keine Konfiguration haben setzen.");
                setAsDefault.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                setAsDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        WebAisMandatorComposite.this.setDefaultCredentialsConfig(CredentialsDialog.this.customerTxt.getText(), CredentialsDialog.this.usernameTxt.getText(), CredentialsDialog.this.passwordTxt.getText(), CredentialsDialog.this.requesterTxt.getText());
                    }
                });
            }
            return ret;
        }

        private void loadFromConfig() {
            this.customerTxt.setText(ConfigServiceHolder.get().get((IContact)WebAisMandatorComposite.this.mandator, "Medics_LaborOrder/customer", ""));
            this.usernameTxt.setText(ConfigServiceHolder.get().get((IContact)WebAisMandatorComposite.this.mandator, "Medics_LaborOrder/username", ""));
            this.passwordTxt.setText(ConfigServiceHolder.get().get((IContact)WebAisMandatorComposite.this.mandator, "Medics_LaborOrder/password", ""));
            this.requesterTxt.setText(ConfigServiceHolder.get().get((IContact)WebAisMandatorComposite.this.mandator, "Medics_LaborOrder/requester", ""));
        }

        protected void okPressed() {
            WebAisMandatorComposite.this.setCredentialsConfig(WebAisMandatorComposite.this.mandator, this.customerTxt.getText(), this.usernameTxt.getText(), this.passwordTxt.getText(), this.requesterTxt.getText());
            super.okPressed();
        }
    }
}

