/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.medics.v2.order;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public class PatientData {
    private String lastName;
    private String firstName;
    private String title;
    private String salutation;
    private String gender;
    private String birthdate;
    private String street;
    private String houseNumber;
    private String city;
    private String postalCode;
    private String country;
    private String phoneNumber;
    private String eMail;
    private String externalPID;
    private String externalSystem;
    private String externalOrderNumber;
    private String insuranceNumber;
    private String insuranceName;
    private String insuranceInstituteNumber;
    private String requesterKey;
    private String officialPatientId;
    private String officialPatientRegistry;

    public static PatientData of(IPatient patient) {
        IXid socialSecurityNumber;
        ICoverage insuranceInfoFall;
        PatientData ret = new PatientData();
        ret.externalSystem = "elexis";
        ret.externalPID = patient.getPatientNr();
        ret.lastName = patient.getLastName();
        ret.firstName = patient.getFirstName();
        if (StringUtils.isNotBlank((CharSequence)patient.getTitel())) {
            ret.title = patient.getTitel();
        }
        if (StringUtils.isNotBlank((CharSequence)PersonFormatUtil.getSalutation((IPerson)patient))) {
            ret.salutation = PersonFormatUtil.getSalutation((IPerson)patient);
        }
        if (StringUtils.isNotBlank((CharSequence)PersonFormatUtil.getSalutation((IPerson)patient))) {
            ret.salutation = PersonFormatUtil.getSalutation((IPerson)patient);
        }
        ret.gender = patient.getGender().value();
        if (patient.getDateOfBirth() != null) {
            ret.birthdate = patient.getDateOfBirth().toLocalDate().toString();
        }
        if (StringUtils.isNotBlank((CharSequence)patient.getStreet())) {
            ret.street = patient.getStreet();
        }
        if (StringUtils.isNotBlank((CharSequence)patient.getCity())) {
            ret.city = patient.getCity();
        }
        if (StringUtils.isNotBlank((CharSequence)patient.getZip())) {
            ret.postalCode = patient.getZip();
        }
        if (patient.getCountry() != null) {
            ret.country = patient.getCountry().name();
        }
        StringJoiner sj = new StringJoiner(", ");
        if (StringUtils.isNotBlank((CharSequence)patient.getPhone1())) {
            sj.add(patient.getPhone1());
        }
        if (StringUtils.isNotBlank((CharSequence)patient.getMobile())) {
            sj.add(patient.getMobile());
        }
        if (StringUtils.isNotBlank((CharSequence)sj.toString())) {
            ret.phoneNumber = sj.toString();
        }
        if (StringUtils.isNotBlank((CharSequence)patient.getEmail())) {
            ret.eMail = patient.getEmail();
        }
        if ((insuranceInfoFall = PatientData.getFallWithInsuranceInfo(patient)) != null) {
            IContact costbearer;
            String insuredNumber = PatientData.getInsuredNumber(insuranceInfoFall);
            if (StringUtils.isNotBlank((CharSequence)insuredNumber)) {
                ret.insuranceNumber = insuredNumber;
            }
            if ((costbearer = insuranceInfoFall.getCostBearer()) != null && costbearer.isOrganization()) {
                String ean;
                if (StringUtils.isNotBlank((CharSequence)costbearer.getDescription1())) {
                    ret.insuranceName = costbearer.getDescription1();
                }
                if (costbearer.getXid("www.xid.ch/id/ean") != null && StringUtils.isNotBlank((CharSequence)(ean = costbearer.getXid("www.xid.ch/id/ean").getDomainId().trim()))) {
                    ret.insuranceInstituteNumber = ean;
                }
            }
        }
        if ((socialSecurityNumber = patient.getXid("www.ahv.ch/xid")) != null) {
            String ssn = socialSecurityNumber.getDomainId().trim();
            String ssnNoDots = ssn.replaceAll("\\.", "");
            if (ssnNoDots.length() == 11) {
                ret.officialPatientId = ssnNoDots;
                ret.officialPatientRegistry = "AHV";
            } else if (ssnNoDots.length() == 13) {
                ret.officialPatientId = ssnNoDots;
                ret.officialPatientRegistry = "AHV";
            }
        }
        return ret;
    }

    private static ICoverage getFallWithInsuranceInfo(IPatient patient) {
        ICoverage selected = ContextServiceHolder.get().getTyped(ICoverage.class).orElse(null);
        if (selected != null && PatientData.hasInsuranceInfo(selected) && selected.getBillingSystem().getLaw() == BillingLaw.KVG) {
            return selected;
        }
        ICoverage ret = null;
        for (ICoverage coverage : patient.getCoverages()) {
            if (!coverage.isOpen() || !PatientData.hasInsuranceInfo(coverage)) continue;
            if (ret == null) {
                ret = coverage;
                continue;
            }
            if (coverage.getBillingSystem().getLaw() != BillingLaw.KVG) continue;
            ret = coverage;
        }
        return ret;
    }

    private static boolean hasInsuranceInfo(ICoverage fall) {
        return StringUtils.isNotBlank((CharSequence)((String)fall.getExtInfo((Object)"Versicherungsnummer")));
    }

    private static String getInsuredNumber(ICoverage insuranceInfoFall) {
        if (StringUtils.isNotBlank((CharSequence)((String)insuranceInfoFall.getExtInfo((Object)"Versicherungsnummer")))) {
            return CoverageServiceHolder.get().getRequiredString(insuranceInfoFall, "Versicherungsnummer");
        }
        return "";
    }

    public PatientData withRequesterKey(String requesterKey) {
        this.requesterKey = requesterKey;
        return this;
    }
}

