/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.hl7.universal;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.preferences.inputs.ComboFieldEditor;
import ch.elexis.laborimport.hl7.universal.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CFG_DIRECTORY = "hl7/downloaddir";
    public static final String CFG_DIRECTORY_AUTOIMPORT = "hl7/autoimport";
    private IDocumentManager docManager;
    private ComboFieldEditor comboField;

    public Preferences() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
        Object os = Extensions.findBestService((String)"DocumentManagement");
        if (os instanceof IDocumentManager) {
            this.docManager = (IDocumentManager)os;
        }
    }

    protected void createFieldEditors() {
        String[] categories;
        this.addField((FieldEditor)new DirectoryFieldEditor(CFG_DIRECTORY, Messages.Prefs_ImportDirectory, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("hl7Parser/importencdata", Messages.Prefs_ImportAttachedFiles, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(CFG_DIRECTORY_AUTOIMPORT, "Verzeichnis \u00fcberwachen und automatisch importieren", this.getFieldEditorParent()));
        if (this.docManager != null && (categories = this.docManager.getCategories()) != null && categories.length > 0) {
            this.comboField = new ComboFieldEditor("hl7Parser/importencdataCategory", "Bitte w\u00e4hlen Sie eine Omnivore-Kategorie f\u00fcr den Import", categories, this.getFieldEditorParent());
            this.addField((FieldEditor)this.comboField);
            this.changeVisiblityOfComboCategory(CoreHub.localCfg.get("hl7Parser/importencdata", false));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor bf;
        super.propertyChange(event);
        if (event.getSource() instanceof FieldEditor && "hl7Parser/importencdata".equals((bf = (FieldEditor)event.getSource()).getPreferenceName())) {
            this.changeVisiblityOfComboCategory(event.getNewValue() == Boolean.TRUE);
        }
    }

    private void changeVisiblityOfComboCategory(boolean visible) {
        if (this.comboField != null) {
            this.comboField.getLabelControl(this.getFieldEditorParent()).setVisible(visible);
            this.comboField.getCombo().setVisible(visible);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        super.performApply();
        CoreHub.localCfg.flush();
    }
}

