/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.eurolyser;

import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.importer.div.importers.DefaultLabImportUiHandler;
import ch.elexis.data.Patient;
import ch.elexis.laborimport.eurolyser.EurolyserLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class EurolyserImporter {
    public static final String CONFIG_IMPORT_MANDANTONLY = "eurolyser/import/mandantonly";
    private File file;
    private ILaboratory labor;
    private HashMap<String, IPatient> filePatientMap = new HashMap();

    public EurolyserImporter(ILaboratory eurolyserLabor, File file) {
        this.file = file;
        this.labor = eurolyserLabor;
    }

    public boolean createResults() {
        ArrayList<TransientLabResult> results = new ArrayList<TransientLabResult>();
        List<String> lines = this.readFile();
        try {
            for (String line : lines) {
                TransientLabResult result;
                EurolyserLine eurolyserLine;
                if (line == null || line.isEmpty() || !(eurolyserLine = new EurolyserLine(this.labor, line)).isRelevant() || (result = eurolyserLine.createResult(this.filePatientMap)) == null) continue;
                results.add(result);
            }
            HashMap<Patient, List<TransientLabResult>> resultsMap = this.getGroupedResults(results);
            Set<Patient> keys = resultsMap.keySet();
            for (Patient patient : keys) {
                List<TransientLabResult> patResults = resultsMap.get(patient);
                LabImportUtilHolder.get().importLabResults(patResults, (ImportHandler)new DefaultLabImportUiHandler());
            }
            return !resultsMap.isEmpty();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private HashMap<Patient, List<TransientLabResult>> getGroupedResults(List<TransientLabResult> results) {
        HashMap<Patient, List<TransientLabResult>> ret = new HashMap<Patient, List<TransientLabResult>>();
        for (TransientLabResult transientLabResult : results) {
            List<TransientLabResult> patResults = ret.get(transientLabResult.getPatient());
            if (patResults == null) {
                patResults = new ArrayList<TransientLabResult>();
                patResults.add(transientLabResult);
                Patient pat = Patient.load((String)transientLabResult.getPatient().getId());
                ret.put(pat, patResults);
                continue;
            }
            patResults.add(transientLabResult);
        }
        return ret;
    }

    private List<String> readFile() {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(this.file));){
                String line;
                while ((line = br.readLine()) != null) {
                    ret.add(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("File [" + this.file.getAbsolutePath() + "] is not valid.");
        }
        return ret;
    }
}

