/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.bioanalytica;

import ch.elexis.core.data.util.PlatformHelper;
import ch.elexis.core.importer.div.importers.ILabItemResolver;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.data.LabItem;
import ch.elexis.data.Query;
import ch.elexis.hl7.model.AbstractData;
import ch.elexis.hl7.model.LabResultData;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Groups
implements ILabItemResolver {
    private static final String GROUPS_FILE = "/rsc/groups.dat";
    private static final String CODES_FILE = "/rsc/codes.dat";
    private static final String UNKNOWN_PREFIX = "00 Automatisch";
    private static final String DEFAULT_ORDER = "000";
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final String CHARSET = "UTF-8";
    private static HashMap<String, Group> groups = null;
    private static HashMap<String, Code> codes = null;

    static {
        Groups.init();
    }

    public static void main(String[] args) {
        System.out.println("Groups");
    }

    private static final InputStreamReader getFileAsSreamReader(String path) {
        String basePath = PlatformHelper.getBasePath((String)"ch.elexis.laborimport.bioanalytica");
        File file = new File(basePath + path);
        if (file.exists() && file.isFile()) {
            try {
                return new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            }
            catch (FileNotFoundException ex) {
                ExHandler.handle((Throwable)ex);
                return null;
            }
            catch (UnsupportedEncodingException ex) {
                ExHandler.handle((Throwable)ex);
                return null;
            }
        }
        return null;
    }

    private static void init() {
        if (groups == null || codes == null) {
            Groups.loadData();
        }
    }

    private static void loadData() {
        groups = new HashMap();
        codes = new HashMap();
        try {
            String line;
            BufferedReader in;
            InputStreamReader isr = Groups.getFileAsSreamReader(GROUPS_FILE);
            if (isr != null) {
                in = new BufferedReader(isr);
                while ((line = in.readLine()) != null) {
                    Groups.parseGroup(line);
                }
                in.close();
            }
            if ((isr = Groups.getFileAsSreamReader(CODES_FILE)) != null) {
                in = new BufferedReader(isr);
                while ((line = in.readLine()) != null) {
                    Groups.parseCode(line);
                }
                in.close();
            }
        }
        catch (Throwable ex) {
            groups = null;
            codes = null;
        }
    }

    private static void parseGroup(String line) {
        Pattern p;
        Matcher m;
        if (!Groups.isCommentLine(line) && (m = (p = Pattern.compile("^([^;]+);([^;]+)$")).matcher(line)).matches()) {
            String key = m.group(1).trim();
            String name = m.group(2).trim();
            Group group = new Group(key, name);
            groups.put(key, group);
        }
    }

    private static void parseCode(String line) {
        Pattern p;
        Matcher m;
        if (!Groups.isCommentLine(line) && (m = (p = Pattern.compile("^([0-9]+);([^;]+);([^;]+)(;([^;]*))?")).matcher(line)).matches()) {
            Group group;
            String order = m.group(1).trim();
            String key = m.group(2).trim();
            String groupKey = m.group(3).trim();
            String name = "";
            if (m.group(5) != null) {
                name = m.group(5);
            }
            if ((group = groups.get(groupKey)) != null) {
                Code code = new Code(group, key, name, order);
                codes.put(key, code);
            }
        }
    }

    private static boolean isCommentLine(String line) {
        return line.matches("^\\s*#.*$") || line.matches("^\\s*$");
    }

    public static String getGroupNameOfCode(String key) {
        Object name;
        Groups.init();
        Code code = codes.get(key);
        if (code != null) {
            Group group = groups.get(code.group.key);
            name = group.key + " " + group.name;
        } else {
            String dat = new TimeTool().toString(4);
            name = UNKNOWN_PREFIX;
        }
        return name;
    }

    public static String getCodeName(String key) {
        Groups.init();
        Code code = codes.get(key);
        if (code != null) {
            if (!StringTool.isNothing((Object)code.name)) {
                return code.name;
            }
            return key;
        }
        return key;
    }

    public static String getCodeOrderByGroupName(String groupName, ILaboratory labor) {
        String order;
        Query query = new Query(LabItem.class);
        query.add("Gruppe", "=", groupName);
        query.add("LaborID", "=", labor.getId());
        List labItems = query.execute();
        if (labItems != null) {
            int lastPrioValue = 0;
            for (LabItem labItem : labItems) {
                String currentPrio = labItem.getPrio().trim();
                if (currentPrio.length() != 3) continue;
                try {
                    int currentPrioValue = Integer.parseInt(currentPrio);
                    if (currentPrioValue <= lastPrioValue) continue;
                    lastPrioValue = currentPrioValue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            order = String.format("%03d", lastPrioValue + 1);
        } else {
            order = DEFAULT_ORDER;
        }
        return order;
    }

    public String getTestGroupName(AbstractData data) {
        if (data instanceof LabResultData) {
            LabResultData labData = (LabResultData)data;
            return Groups.getGroupNameOfCode(labData.getCode());
        }
        return Groups.getGroupNameOfCode(data.getName() + " " + data.getGroup());
    }

    public String getTestName(AbstractData data) {
        if (data instanceof LabResultData) {
            LabResultData labData = (LabResultData)data;
            return Groups.getCodeName(labData.getCode());
        }
        return Groups.getCodeName(data.getName());
    }

    public String getNextTestGroupSequence(AbstractData data) {
        ILaboratory labor = LabImportUtilHolder.get().getOrCreateLabor("Bioanalytica");
        return Groups.getCodeOrderByGroupName(this.getTestGroupName(data), labor);
    }

    static class Code {
        Group group;
        String key;
        String name;
        String order;

        Code(Group group, String key, String name, String order) {
            this.group = group;
            this.key = key;
            this.name = name;
            this.order = order;
        }
    }

    static class Group {
        String key;
        String name;

        Group(String key, String name) {
            this.key = key;
            this.name = name;
        }
    }
}

