/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.analytica;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.FileUtility;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.importer.div.importers.DefaultHL7Parser;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.laborimport.analytica.Messages;
import ch.ngiger.comm.ftp.FtpSemaException;
import ch.ngiger.comm.ftp.FtpServer;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Importer
extends ImporterPage {
    public static final String MY_LAB = "Analytica";
    public static final String PLUGIN_ID = "ch.elexis.laborimport_analytica";
    private static Logger logger = LoggerFactory.getLogger(Importer.class);
    private static final String COMMENT_NAME = "Kommentar";
    private static final String COMMENT_CODE = "kommentar";
    private static final String COMMENT_GROUP = "00 Kommentar";
    private static final String PRAXIS_SEMAPHORE = "praxis.sem";
    private static final String LABOR_SEMAPHORE = "labor.sem";
    private static final int FILE = 1;
    private static final int DIRECT = 2;
    private HL7Parser hlp = new DefaultHL7Parser("Analytica");

    public Composite createPage(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        LabImporter labImporter = new LabImporter(ret, this);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        labImporter.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        return ret;
    }

    private Result<?> importFile(String filepath) {
        File file = new File(filepath);
        Result rs = null;
        try {
            rs = this.hlp.importFile(file, null, false);
        }
        catch (IOException e) {
            SWTHelper.showError((String)"Import error", (String)e.getMessage());
        }
        if (rs != null && rs.isOK() && !file.delete()) {
            logger.warn("Datei " + file.getPath() + " konnte nicht gel\u00f6scht werden.");
        }
        return rs;
    }

    private Result<?> importDirect() {
        return this.importDirectFtp();
    }

    private Result<?> importDirectFtp() {
        Result result = new Result((Object)Messages.Importer_ok);
        String ftpHost = ConfigServiceHolder.getGlobal((String)"analytica/ftp_host", (String)"172.23.45.1");
        String user = ConfigServiceHolder.getGlobal((String)"analytica/ftp_user", (String)"");
        String pwd = ConfigServiceHolder.getGlobal((String)"analytica/ftp_pwd", (String)"");
        String downloadDir = FileUtility.getCorrectPath((String)ConfigServiceHolder.getGlobal((String)"analytica/downloaddir", (String)"C:\\LaborDownloads"));
        FtpServer ftp = new FtpServer();
        try {
            Vector<String> hl7FileList = new Vector<String>();
            try {
                ftp.openConnection(ftpHost, user, pwd);
                ftp.addSemaphore(downloadDir, PRAXIS_SEMAPHORE, LABOR_SEMAPHORE);
                String[] filenameList = ftp.listNames();
                logger.info("Verbindung mit Labor Analytica erfolgreich. " + filenameList.length + " Dateien gefunden.");
                String[] stringArray = filenameList;
                int n = filenameList.length;
                int n2 = 0;
                while (n2 < n) {
                    String filename = stringArray[n2];
                    if (filename.toUpperCase().endsWith("HL7")) {
                        ftp.downloadFile(filename, downloadDir + filename);
                        logger.info("Datei <" + filename + "> downloaded.");
                        hl7FileList.add(filename);
                        ftp.deleteFile(filename);
                    }
                    ++n2;
                }
            }
            finally {
                if (ftp.isConnected()) {
                    ftp.removeSemaphore();
                    ftp.closeConnection();
                }
            }
            String header = MessageFormat.format(Messages.Importer_import_header, MY_LAB);
            String question = MessageFormat.format(Messages.Importer_import_message, hl7FileList.size(), downloadDir);
            if (SWTHelper.askYesNo((String)header, (String)question)) {
                for (String filename : hl7FileList) {
                    this.importFile(downloadDir + filename);
                    logger.info("Datei <" + filename + "> verarbeitet.");
                }
            }
        }
        catch (IOException e) {
            result = new Result(Result.SEVERITY.ERROR, 1, e.getMessage(), (Object)MY_LAB, true);
            ResultAdapter.displayResult((Result)result, (String)Messages.Importer_error_import);
        }
        catch (FtpSemaException e) {
            result = new Result(Result.SEVERITY.WARNING, 1, e.getMessage(), (Object)MY_LAB, true);
            ResultAdapter.displayResult((Result)result, (String)Messages.Importer_error_import);
        }
        return result;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        int type;
        try {
            String sType = this.results[0];
            type = Integer.parseInt(sType);
        }
        catch (NumberFormatException ex) {
            type = 1;
        }
        if (type != 1 && type != 2) {
            type = 1;
        }
        if (type == 1) {
            String filename = this.results[1];
            Result<?> res = this.importFile(filename);
            if (res != null) {
                return ResultAdapter.getResultAsStatus(res);
            }
        } else {
            Result<?> res = this.importDirect();
            if (res != null) {
                return ResultAdapter.getResultAsStatus(res);
            }
        }
        return Status.CANCEL_STATUS;
    }

    public String getDescription() {
        return Messages.Importer_title_description;
    }

    public String getTitle() {
        return Messages.Importer_lab + MY_LAB;
    }

    public List<String> getObjectClass() {
        return Arrays.asList(ILabResult.class.getName(), "ch.elexis.omnivore.model.IDocumentHandle");
    }

    String getBasePath() {
        try {
            URL url = Platform.getBundle((String)PLUGIN_ID).getEntry("/");
            url = FileLocator.toFileURL((URL)url);
            String bundleLocation = url.getPath();
            File file = new File(bundleLocation);
            bundleLocation = file.getAbsolutePath();
            return bundleLocation;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private class LabImporter
    extends Composite {
        private final Button bFile;
        private final Button bDirect;
        private final Text tFilename;

        public LabImporter(final Composite parent, final ImporterPage home) {
            super(parent, 2048);
            this.setLayout((Layout)new GridLayout(3, false));
            this.bFile = new Button((Composite)this, 16);
            this.bFile.setText(Messages.Importer_label_importFile);
            this.bFile.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
            Label lFile = new Label((Composite)this, 0);
            lFile.setText("    " + Messages.ImporterPage_file);
            GridData gd = SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false);
            gd.horizontalAlignment = 3;
            gd.widthHint = lFile.getSize().x + 20;
            this.tFilename = new Text((Composite)this, 2048);
            this.tFilename.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Button bBrowse = new Button((Composite)this, 8);
            bBrowse.setText(Messages.ImporterPage_browse);
            String direktHerkunft = Messages.Importer_ftp_label;
            this.bDirect = new Button((Composite)this, 16);
            this.bDirect.setText(Messages.Importer_label_importDirect + " (" + direktHerkunft + ")");
            this.bDirect.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
            int type = CoreHub.localCfg.get("ImporterPage/" + home.getTitle() + "/type", 1);
            home.results = new String[2];
            if (type == 1) {
                this.bFile.setSelection(true);
                this.bDirect.setSelection(false);
                String filename = CoreHub.localCfg.get("ImporterPage/" + home.getTitle() + "/filename", "");
                this.tFilename.setText(filename);
                home.results[0] = new Integer(1).toString();
                home.results[1] = filename;
            } else {
                this.bFile.setSelection(false);
                this.bDirect.setSelection(true);
                this.tFilename.setText("");
                home.results[0] = new Integer(2).toString();
                home.results[1] = "";
            }
            SelectionAdapter sa = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    if (!button.getSelection()) {
                        return;
                    }
                    int type = 1;
                    if (button == LabImporter.this.bFile) {
                        type = 1;
                    } else if (button == LabImporter.this.bDirect) {
                        type = 2;
                    }
                    if (type == 1) {
                        LabImporter.this.bFile.setSelection(true);
                        LabImporter.this.bDirect.setSelection(false);
                        String filename = LabImporter.this.tFilename.getText();
                        home.results[0] = new Integer(1).toString();
                        home.results[1] = filename;
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/type", 1);
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/filename", filename);
                    } else {
                        LabImporter.this.bFile.setSelection(false);
                        LabImporter.this.bDirect.setSelection(true);
                        LabImporter.this.tFilename.setText("");
                        home.results[0] = new Integer(2).toString();
                        home.results[1] = "";
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/type", 2);
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/filename", "");
                    }
                }
            };
            this.bFile.addSelectionListener((SelectionListener)sa);
            this.bDirect.addSelectionListener((SelectionListener)sa);
            bBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LabImporter.this.bFile.setSelection(true);
                    LabImporter.this.bDirect.setSelection(false);
                    FileDialog fdl = new FileDialog(parent.getShell(), 4096);
                    fdl.setFilterExtensions(new String[]{"*"});
                    fdl.setFilterNames(new String[]{Messages.Core_All_Files});
                    String filename = fdl.open();
                    if (filename == null) {
                        filename = "";
                    }
                    LabImporter.this.tFilename.setText(filename);
                    home.results[0] = new Integer(1).toString();
                    home.results[1] = filename;
                    CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/type", 1);
                    CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/filename", filename);
                }
            });
        }
    }
}

