/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.kassenbuch;

import ch.elexis.buchhaltung.kassenbuch.KassenbuchEintrag;
import ch.elexis.core.time.TimeUtil;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

class KassenbuchViewerComparator
extends ViewerComparator {
    private int propertyIndex = 0;
    private boolean direction = true;

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof KassenbuchEintrag && e2 instanceof KassenbuchEintrag) {
            KassenbuchEintrag kb1 = (KassenbuchEintrag)e1;
            KassenbuchEintrag kb2 = (KassenbuchEintrag)e2;
            Money betrag1 = kb1.getAmount();
            Money betrag2 = kb2.getAmount();
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    try {
                        int belegNr1 = Integer.parseInt(kb1.getBelegNr());
                        int belegNr2 = Integer.parseInt(kb2.getBelegNr());
                        rc = Integer.compare(belegNr1, belegNr2);
                    }
                    catch (NumberFormatException e) {
                        rc = kb1.getBelegNr().compareTo(kb2.getBelegNr());
                    }
                    break;
                }
                case 1: {
                    LocalDate date1 = LocalDate.parse(kb1.getDate(), TimeUtil.DATE_GER);
                    LocalDate date2 = LocalDate.parse(kb2.getDate(), TimeUtil.DATE_GER);
                    rc = date1.compareTo(date2);
                    break;
                }
                case 2: 
                case 3: {
                    rc = Double.compare(betrag1.getAmount(), betrag2.getAmount());
                    break;
                }
                case 4: {
                    rc = kb1.getSaldo().compareTo(kb2.getSaldo());
                    break;
                }
                case 5: {
                    rc = kb1.getKategorie().compareToIgnoreCase(kb2.getKategorie());
                    break;
                }
                case 6: {
                    rc = kb1.getPaymentMode().compareToIgnoreCase(kb2.getPaymentMode());
                    break;
                }
                case 7: {
                    rc = kb1.getText().compareToIgnoreCase(kb2.getText());
                    break;
                }
            }
            if (this.direction) {
                rc = -rc;
            }
            return rc;
        }
        return 0;
    }

    public int getDirection() {
        return this.direction ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = !this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = true;
        }
    }
}

