/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.kassenbuch;

import ch.elexis.buchhaltung.kassenbuch.BuchungsDialog;
import ch.elexis.buchhaltung.kassenbuch.DatumEingabeDialog;
import ch.elexis.buchhaltung.kassenbuch.EditCatsDialog;
import ch.elexis.buchhaltung.kassenbuch.EditPaymentModesDialog;
import ch.elexis.buchhaltung.kassenbuch.KassenbuchDruckDialog;
import ch.elexis.buchhaltung.kassenbuch.KassenbuchEintrag;
import ch.elexis.buchhaltung.kassenbuch.KassenbuchViewerComparator;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.util.SortedSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class KassenView
extends ViewPart
implements IActivationListener,
Heartbeat.HeartListener {
    ScrolledForm form;
    FormToolkit tk;
    TableViewer tv;
    TableColumn[] tc;
    TimeTool ttVon;
    TimeTool ttBis;
    String[] tableHeaders = new String[]{"Beleg", "Datum", "Soll", "Haben", "Saldo", "Kategorie", "Zahlungsart", "Text"};
    int[] tableCols = new int[]{50, 80, 60, 60, 60, 100, 100, 400};
    private IAction addAction;
    private IAction subtractAction;
    private IAction stornoAction;
    private IAction saldoAction;
    private IAction dateAction;
    private IAction printAction;
    private IAction editCatAction;
    private IAction editPaymentAction;
    public static KassenbuchViewerComparator comparator;

    public KassenView() {
        this.ttVon = new TimeTool();
        this.ttBis = new TimeTool();
        this.ttVon.addDays(-14);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createScrolledForm(parent);
        Composite body = this.form.getBody();
        body.setLayout((Layout)new FillLayout());
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tc = new TableColumn[this.tableHeaders.length];
        Table table = new Table(body, 65540);
        this.tv = new TableViewer(table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                SortedSet<KassenbuchEintrag> set = KassenbuchEintrag.getBookings(KassenView.this.ttVon, KassenView.this.ttBis);
                if (set != null) {
                    return set.toArray();
                }
                return new KassenbuchEintrag[0];
            }
        });
        comparator = new KassenbuchViewerComparator();
        this.tv.setComparator((ViewerComparator)comparator);
        int i = 0;
        while (i < this.tc.length) {
            this.tc[i] = new TableColumn(table, 0);
            this.tc[i].setText(this.tableHeaders[i]);
            this.tc[i].setWidth(this.tableCols[i]);
            this.tc[i].addSelectionListener((SelectionListener)this.getSelectionAdapter(this.tc[i], i));
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tv.setLabelProvider((IBaseLabelProvider)new KBLabelProvider());
        this.tv.setUseHashlookup(true);
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.addAction, this.subtractAction, this.saldoAction});
        menu.createViewerContextMenu((StructuredViewer)this.tv, new IAction[]{this.stornoAction});
        menu.createMenu(new IAction[]{this.dateAction, this.printAction, null, this.editCatAction, this.editPaymentAction});
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)KassenView.this.tv.getSelection();
                if (!sel.isEmpty()) {
                    KassenbuchEintrag kbe = (KassenbuchEintrag)sel.getFirstElement();
                    if (new BuchungsDialog(KassenView.this.getSite().getShell(), kbe).open() == 0) {
                        KassenView.this.tv.refresh();
                    }
                }
            }
        });
        this.tv.setInput((Object)this);
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.setFormText();
    }

    private void setFormText() {
        if (this.ttVon == null) {
            this.form.setText("Anzeige: Alle Buchungen");
        } else {
            this.form.setText("Anzeige: Von " + this.ttVon.toString(4) + " bis: " + this.ttBis.toString(4));
        }
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.addAction = new RestrictedAction((EvaluatableACE)EvACE.of(KassenbuchEintrag.class, (Right)Right.CREATE), "Einnahme"){
            {
                this.setImageDescriptor(Images.IMG_ADD.getImageDescriptor());
                this.setToolTipText("Einnahme verbuchen");
            }

            public void doRun() {
                new BuchungsDialog(KassenView.this.getSite().getShell(), true).open();
                KassenView.this.tv.refresh();
            }
        };
        this.subtractAction = new RestrictedAction((EvaluatableACE)EvACE.of(KassenbuchEintrag.class, (Right)Right.CREATE), "Ausgabe"){
            {
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
                this.setToolTipText("Ausgabe verbuchen");
            }

            public void doRun() {
                new BuchungsDialog(KassenView.this.getSite().getShell(), false).open();
                KassenView.this.tv.refresh();
            }
        };
        this.stornoAction = new RestrictedAction((EvaluatableACE)EvACE.of(KassenbuchEintrag.class, (Right)Right.UPDATE), "Storno"){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText("Buchung stornieren");
            }

            public void doRun() {
                IStructuredSelection sel = (IStructuredSelection)KassenView.this.tv.getSelection();
                if (!sel.isEmpty()) {
                    KassenbuchEintrag kb = (KassenbuchEintrag)sel.getFirstElement();
                    kb.delete();
                    KassenbuchEintrag.recalc();
                    KassenView.this.tv.refresh();
                }
            }
        };
        this.saldoAction = new RestrictedAction((EvaluatableACE)EvACE.of(KassenbuchEintrag.class, (Right)Right.CREATE), "Saldo"){
            {
                this.setImageDescriptor(KassenView.getPluginImageDescriptor("icons/sigma.ico"));
                this.setToolTipText("Zwischenbilanz erstellen");
            }

            public void doRun() {
                InputDialog inp = new InputDialog(KassenView.this.getSite().getShell(), "Kassenbestand abgleichen", "Geben Sie bitte den abgez\u00e4hlten Betrag in der Kasse ein", "0.00", null);
                if (inp.open() == 0) {
                    try {
                        Money money = new Money(inp.getValue());
                        if (!money.isZero()) {
                            KassenbuchEintrag last = KassenbuchEintrag.recalc();
                            Money soll = last.getSaldo();
                            Money diff = money.subtractMoney(soll);
                            new KassenbuchEintrag(KassenbuchEintrag.nextNr(last) + " Kontrolle", new TimeTool().toString(4), diff, diff.isNegative() ? "Fehlbetrag" : "\u00dcberschuss");
                            KassenView.this.tv.refresh();
                        }
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        SWTHelper.alert((String)"Fehler", (String)"Die Eingabe im Betragsfeld war ung\u00fcltig");
                    }
                }
            }
        };
        this.dateAction = new RestrictedAction((EvaluatableACE)EvACE.of(KassenbuchEintrag.class, (Right)Right.VIEW), "Zeitraum"){
            {
                this.setImageDescriptor(KassenView.getPluginImageDescriptor("icons/calendar.png"));
                this.setToolTipText("Anzeigezeitraum einstellen");
            }

            public void doRun() {
                DatumEingabeDialog ded = new DatumEingabeDialog(KassenView.this.getViewSite().getShell(), KassenView.this.ttVon, KassenView.this.ttBis);
                if (ded.open() == 0) {
                    KassenView.this.ttVon = ded.ttVon;
                    KassenView.this.ttBis = ded.ttBis;
                } else {
                    KassenView.this.ttVon = null;
                    KassenView.this.ttBis = null;
                }
                KassenView.this.setFormText();
                KassenView.this.tv.refresh();
            }
        };
        this.printAction = new RestrictedAction((EvaluatableACE)EvACE.of(KassenbuchEintrag.class, (Right)Right.VIEW), "Drucken"){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                KassenView.this.setTitleToolTip("Angezeigte Buchungen ausdrucken");
            }

            public void doRun() {
                KassenbuchDruckDialog kbd = new KassenbuchDruckDialog(KassenView.this.getSite().getShell(), KassenView.this.ttVon, KassenView.this.ttBis);
                kbd.open();
            }
        };
        this.editCatAction = new RestrictedAction((EvaluatableACE)EvACE.of(KassenbuchEintrag.class, (Right)Right.CREATE), "Kategorien..."){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                KassenView.this.setTitleToolTip("Kategorien editieren");
            }

            public void doRun() {
                new EditCatsDialog(KassenView.this.getSite().getShell()).open();
            }
        };
        this.editPaymentAction = new RestrictedAction((EvaluatableACE)EvACE.of(KassenbuchEintrag.class, (Right)Right.CREATE), "Zahlungsart..."){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                KassenView.this.setTitleToolTip("Zahlungsart editieren");
            }

            public void doRun() {
                new EditPaymentModesDialog(KassenView.this.getSite().getShell()).open();
            }
        };
    }

    public static ImageDescriptor getPluginImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.kassenbuch", (String)path);
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            this.tv.refresh();
            CoreHub.heart.addListener((Heartbeat.HeartListener)this);
        } else {
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        }
    }

    public void heartbeat() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                KassenView.this.tv.refresh();
            }
        });
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                KassenView.this.tv.getTable().setSortDirection(comparator.getDirection());
                KassenView.this.tv.getTable().setSortColumn(column);
                KassenView.this.tv.refresh();
            }
        };
        return selectionAdapter;
    }

    class KBLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        KBLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            KassenbuchEintrag kb = (KassenbuchEintrag)element;
            Money betrag = kb.getAmount();
            switch (columnIndex) {
                case 0: {
                    return kb.get("BelegNr");
                }
                case 1: {
                    return kb.getDate();
                }
                case 2: {
                    return betrag.isNegative() ? "" : betrag.getAmountAsString();
                }
                case 3: {
                    return betrag.isNegative() ? new Money(betrag).negate().getAmountAsString() : "";
                }
                case 4: {
                    return kb.getSaldo().getAmountAsString();
                }
                case 5: {
                    return kb.getKategorie();
                }
                case 6: {
                    return kb.getPaymentMode();
                }
                case 7: {
                    return kb.getText();
                }
            }
            return "?";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 4) {
                KassenbuchEintrag kb = (KassenbuchEintrag)element;
                if (kb.getSaldo().isNegative()) {
                    return UiDesk.getColor((String)"rot");
                }
                return UiDesk.getColor((String)"schwarz");
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }
    }
}

