/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.impfplan.view;

import ch.elexis.core.ui.selectors.DisplayPanel;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.PersistentObject;
import ch.elexis.impfplan.model.DiseaseDefinitionModel;
import ch.elexis.impfplan.model.VaccinationType;
import ch.elexis.impfplan.view.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class EditVaccinationDialog
extends TitleAreaDialog {
    CheckboxTreeViewer treeViewer;
    VaccinationType vt;
    FieldDescriptor<VaccinationType>[] fields = new FieldDescriptor[]{new FieldDescriptor(Messages.EditVaccinationDialog_nameOfVaccination, "name", FieldDescriptor.Typ.STRING, null), new FieldDescriptor(Messages.EditVaccinationDialog_vaccinationSubstance, "product", null), new FieldDescriptor(Messages.EditVaccinationDialog_ageFromTo, "recommendedAge", null), new FieldDescriptor(Messages.EditVaccinationDialog_distance1_2, "delay_1to2", null), new FieldDescriptor(Messages.EditVaccinationDialog_distance2_3, "delay_2to3", null), new FieldDescriptor(Messages.EditVaccinationDialog_distance3_4, "delay_3to4", null), new FieldDescriptor(Messages.EditVaccinationDialog_distanceRappel, "delay_rep", null), new FieldDescriptor(Messages.EditVaccinationDialog_remarks, "remarks", null)};

    public EditVaccinationDialog(Shell shell, VaccinationType vacc) {
        super(shell);
        this.vt = vacc;
    }

    protected Control createDialogArea(Composite parent) {
        DisplayPanel panel = new DisplayPanel(parent, this.fields, 2, 2, new IAction[0]);
        panel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        panel.setAutosave(true);
        panel.setObject((PersistentObject)this.vt);
        Composite treeComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginLeft = 5;
        treeComposite.setLayout((Layout)gridLayout);
        treeComposite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.treeViewer = new CheckboxTreeViewer(treeComposite, 68096);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(16384, 128, true, true));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeViewerColumn col = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        col.getColumn().setWidth(225);
        col.getColumn().setText("Impfung gegen Krankheit(en)");
        this.treeViewer.setContentProvider((IContentProvider)new DiseaseTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DiseaseTreeLabelProvider());
        this.treeViewer.setInput(DiseaseDefinitionModel.getDiseaseDefinitions());
        this.treeViewer.setCheckedElements(this.loadSelected().toArray());
        return panel;
    }

    private List<DiseaseDefinitionModel.DiseaseDefinition> loadSelected() {
        List<DiseaseDefinitionModel.DiseaseDefinition> diseaseDefinitions = DiseaseDefinitionModel.getDiseaseDefinitions();
        ArrayList<DiseaseDefinitionModel.DiseaseDefinition> selected = new ArrayList<DiseaseDefinitionModel.DiseaseDefinition>();
        for (String code : this.vt.getVaccAgainstList()) {
            for (DiseaseDefinitionModel.DiseaseDefinition dd : diseaseDefinitions) {
                if (!dd.getATCCode().equals(code)) continue;
                selected.add(dd);
            }
        }
        return selected;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.EditVaccinationDialog_enterVaccination);
        this.getShell().setText(Messages.EditVaccinationDialog_defineVaccination);
        this.getShell().setSize(800, 600);
        SWTHelper.center((Shell)this.getShell());
    }

    protected void okPressed() {
        Object[] checkedElements = this.treeViewer.getCheckedElements();
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            DiseaseDefinitionModel.DiseaseDefinition disease = (DiseaseDefinitionModel.DiseaseDefinition)element;
            sb.append(disease.getATCCode());
            sb.append(",");
            ++n2;
        }
        this.vt.setVaccAgainst(sb.toString());
        super.okPressed();
    }

    private class DiseaseTreeContentProvider
    implements ITreeContentProvider {
        private DiseaseTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return DiseaseDefinitionModel.getDiseaseDefinitions().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return (DiseaseDefinitionModel.DiseaseDefinition)element;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class DiseaseTreeLabelProvider
    implements ILabelProvider {
        private DiseaseTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((DiseaseDefinitionModel.DiseaseDefinition)element).getDiseaseLabel();
        }
    }
}

