/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.impfplan.view;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.impfplan.controller.ImpfplanController;
import ch.elexis.impfplan.model.VaccinationType;
import ch.elexis.impfplan.view.ContentProviderAdapter;
import ch.elexis.impfplan.view.EditVaccinationDialog;
import ch.elexis.impfplan.view.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ImpfplanPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IAction removeAction;
    private IAction editAction;
    private TableViewer tv;

    public ImpfplanPreferences() {
        this.makeActions();
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout());
        this.tv = new TableViewer(ret);
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tv.setContentProvider((IContentProvider)new ContentProviderAdapter(){

            @Override
            public Object[] getElements(Object arg0) {
                return ImpfplanController.allVaccs().toArray();
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof VaccinationType) {
                    return ((VaccinationType)((Object)element)).getLabel();
                }
                return "?";
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ImpfplanPreferences.this.edit();
            }
        });
        Composite cButtons = new Composite(ret, 0);
        cButtons.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        cButtons.setLayout((Layout)new RowLayout(256));
        Button bAdd = new Button(cButtons, 8);
        bAdd.setText(Messages.ImpfplanPreferences_addCaption);
        bAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditVaccinationDialog dlg = new EditVaccinationDialog(ImpfplanPreferences.this.getShell(), new VaccinationType(Messages.ImpfplanPreferences_nameDummy, Messages.ImpfplanPreferences_vaccDummy));
                if (dlg.open() == 0) {
                    ImpfplanPreferences.this.tv.refresh();
                }
            }
        });
        MenuManager menu = new MenuManager();
        menu.add(this.removeAction);
        this.tv.getControl().setMenu(menu.createContextMenu(this.tv.getControl()));
        this.tv.setInput((Object)this);
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    private void edit() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        if (!sel.isEmpty()) {
            VaccinationType t = (VaccinationType)((Object)sel.getFirstElement());
            if (new EditVaccinationDialog(this.getShell(), t).open() == 0) {
                this.tv.refresh(true);
            }
        }
    }

    private void makeActions() {
        this.removeAction = new Action(Messages.ImpfplanPreferences_removeVaccination){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.ImpfplanPreferences_removeVaccWarning);
            }

            public void run() {
                VaccinationType t;
                IStructuredSelection sel = (IStructuredSelection)ImpfplanPreferences.this.tv.getSelection();
                if (!sel.isEmpty() && (t = (VaccinationType)((Object)sel.getFirstElement())).delete()) {
                    ImpfplanPreferences.this.tv.remove(sel.getFirstElement());
                }
            }
        };
    }
}

