/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.impfplan.model;

import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DiseaseDefinitionModel {
    public static final String VACCINATION_ATC_GROUP_TRAILER = "J07";
    private static List<DiseaseDefinition> diseases = null;

    public static List<DiseaseDefinition> getDiseaseDefinitions() {
        if (diseases == null) {
            DiseaseDefinitionModel.initDiseases();
        }
        return diseases;
    }

    private static void initDiseases() {
        diseases = new ArrayList<DiseaseDefinition>();
        diseases.add(new DiseaseDefinition("J07AF", "Diphterie", "Diphteria"));
        diseases.add(new DiseaseDefinition("J07AM", "Starrkrampf", "Tetanus"));
        diseases.add(new DiseaseDefinition("J07AJ", "Keuchhusten", "Pertussis"));
        diseases.add(new DiseaseDefinition("J07BF", "Kinderl\u00e4hmung", "Poliomyelitis"));
        diseases.add(new DiseaseDefinition("J07AG", "Haemophilus influenzae (Hib)"));
        diseases.add(new DiseaseDefinition("J07BD", "Masern", "Measles"));
        diseases.add(new DiseaseDefinition("J07BE", "Mumps"));
        diseases.add(new DiseaseDefinition("J07BJ", "R\u00f6teln", "Rubella"));
        diseases.add(new DiseaseDefinition("J07BC01", "Hepatitis B"));
        diseases.add(new DiseaseDefinition("J07BM", "humanes PapillomaVirus"));
        diseases.add(new DiseaseDefinition("J07BB", "Influenza"));
        diseases.add(new DiseaseDefinition("J07BC02", "Hepatitis A*"));
        diseases.add(new DiseaseDefinition("J07AL", "Pneumokokken", "Pneumococca"));
        diseases.add(new DiseaseDefinition("J07AH", "Meningokokken", "Meningococca"));
        diseases.add(new DiseaseDefinition("J07BA01", "FSME", "Encephalitis tick borne"));
        diseases.add(new DiseaseDefinition("J07AP", "Typhus"));
        diseases.add(new DiseaseDefinition("J07BK", "Varizellen", "Varicella zoster"));
        diseases.add(new DiseaseDefinition("J07BL", "Gelbfieber", "Yellow fever"));
        diseases.add(new DiseaseDefinition("J07AE", "Cholera"));
        diseases.add(new DiseaseDefinition("J07BA02", "japanische Encephalitis", "Encephalitis japanese"));
        diseases.add(new DiseaseDefinition("J07BH", "Rotaviren", "Rota virus"));
        diseases.add(new DiseaseDefinition("J07BG", "Tollwut", "Rabies"));
        diseases.add(new DiseaseDefinition("J07AN", "Tuberkulose"));
        diseases.add(new DiseaseDefinition("J07BK01", "Windpocken - Varizellen"));
        diseases = Collections.unmodifiableList(diseases);
    }

    public static String getLabelForAtcCode(String diseaseAtcCode) {
        for (DiseaseDefinition dd : DiseaseDefinitionModel.getDiseaseDefinitions()) {
            if (!diseaseAtcCode.equalsIgnoreCase(dd.ATCCode)) continue;
            return dd.toString();
        }
        return "?????";
    }

    public static class DiseaseDefinition {
        private final String ATCCode;
        private final String diseaseLabel;
        private final String diseaseSynonym;

        public DiseaseDefinition(String atcCode, String diseaseLabel, String diseaseSynonym) {
            this.ATCCode = atcCode;
            this.diseaseLabel = diseaseLabel;
            this.diseaseSynonym = diseaseSynonym;
        }

        public DiseaseDefinition(String atcCode, String diseaseLabel) {
            this(atcCode, diseaseLabel, null);
        }

        @NonNull
        public String getDiseaseLabel() {
            return this.diseaseLabel;
        }

        @NonNull
        public String getATCCode() {
            return this.ATCCode;
        }

        @Nullable
        public String getDiseaseSynonym() {
            return this.diseaseSynonym;
        }

        public String toString() {
            if (this.diseaseSynonym == null) {
                return this.diseaseLabel;
            }
            return this.diseaseLabel + " - " + this.diseaseSynonym;
        }
    }
}

