/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.views;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.actions.ObjectFilterRegistry;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Konsultation;
import ch.elexis.icpc.KonsFilter;
import ch.elexis.icpc.model.icpc.IcpcEpisode;
import ch.elexis.icpc.service.IcpcModelServiceHolder;
import ch.elexis.icpc.views.EditEpisodeDialog;
import ch.elexis.icpc.views.EpisodesDisplay;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class EpisodesView
extends ViewPart {
    public static final String ID = "ch.elexis.icpc.episodesView";
    EpisodesDisplay display;
    KonsFilter episodesFilter = new KonsFilter(this);
    private IAction addEpisodeAction;
    private IAction removeEpisodeAction;
    private IAction editEpisodeAction;
    private IAction activateEpisodeAction;
    private IAction konsFilterAction;
    private IAction removeDiagnosesAction;

    @Inject
    void activePatient(@Optional IPatient patient) {
        if (this.display != null && !this.display.isDisposed()) {
            Display.getDefault().asyncExec(() -> this.display.setPatient(patient));
        }
    }

    @Inject
    void selectedEpisode(@Optional IcpcEpisode episode) {
        if (this.display != null && !this.display.isDisposed()) {
            Display.getDefault().asyncExec(() -> {
                if (episode != null) {
                    if (episode.getStatus() == 1) {
                        this.activateEpisodeAction.setChecked(true);
                    } else {
                        this.activateEpisodeAction.setChecked(false);
                    }
                    if (this.konsFilterAction.isChecked()) {
                        this.episodesFilter.setProblem(episode);
                    }
                } else {
                    this.episodesFilter.setProblem(null);
                }
            });
        }
    }

    @Optional
    @Inject
    void updateEpisode(@UIEventTopic(value="info/elexis/model/update") IcpcEpisode episode) {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.tvEpisodes.refresh();
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.display = new EpisodesDisplay(parent);
        this.display.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createControlContextMenu(this.display.tvEpisodes.getControl(), new ViewMenus.IMenuPopulator(){

            public IAction[] fillMenu() {
                IAction[] iActionArray = new IAction[5];
                iActionArray[0] = EpisodesView.this.activateEpisodeAction;
                iActionArray[1] = EpisodesView.this.editEpisodeAction;
                iActionArray[3] = EpisodesView.this.removeEpisodeAction;
                iActionArray[4] = EpisodesView.this.removeDiagnosesAction;
                return iActionArray;
            }
        });
        menu.createToolbar(new IAction[]{this.konsFilterAction, this.addEpisodeAction, this.editEpisodeAction});
    }

    public void setFocus() {
        this.display.setFocus();
    }

    private void makeActions() {
        this.addEpisodeAction = new Action("Neues Problem"){
            {
                this.setToolTipText("Eine neues Problem erstellen");
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            }

            public void run() {
                EditEpisodeDialog dlg = new EditEpisodeDialog(EpisodesView.this.getViewSite().getShell(), null);
                if (dlg.open() == 0) {
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        };
        this.removeEpisodeAction = new Action("Problem l\u00f6schen"){
            {
                this.setToolTipText("Das gew\u00e4hlte Problem unwiderruflich l\u00f6schen");
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                IcpcEpisode act = EpisodesView.this.display.getSelectedEpisode();
                if (act != null) {
                    IcpcModelServiceHolder.get().delete((Deleteable)act);
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        };
        this.removeDiagnosesAction = new Action("Diagnosen entfernen"){
            {
                this.setToolTipText("Entfernt die Verkn\u00fcpfungen mit Diagnosen");
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
            }

            public void run() {
                IcpcEpisode act = EpisodesView.this.display.getSelectedEpisode();
                if (act != null) {
                    act.getDiagnosis().forEach(d -> act.removeDiagnosis(d));
                    IcpcModelServiceHolder.get().save((Identifiable)act);
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        };
        this.editEpisodeAction = new Action("Problem bearbeiten"){
            {
                this.setToolTipText("Problem bearbeiten");
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
            }

            public void run() {
                EditEpisodeDialog dlg;
                IcpcEpisode ep = EpisodesView.this.display.getSelectedEpisode();
                if (ep != null && (dlg = new EditEpisodeDialog(EpisodesView.this.getViewSite().getShell(), ep)).open() == 0) {
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        };
        this.activateEpisodeAction = new Action("Aktiv", 2){
            {
                this.setToolTipText("Problem aktivieren oder deaktivieren");
            }

            public void run() {
                IcpcEpisode ep = EpisodesView.this.display.getSelectedEpisode();
                if (ep != null) {
                    ep.setStatus(EpisodesView.this.activateEpisodeAction.isChecked() ? 1 : 0);
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        };
        this.konsFilterAction = new Action("Konsultationen filtern", 2){
            {
                this.setToolTipText("Konsultationslisten auf markiertes Problem begrenzen");
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
            }

            public void run() {
                if (!this.isChecked()) {
                    ObjectFilterRegistry.getInstance().unregisterObjectFilter(Konsultation.class, (ObjectFilterRegistry.IObjectFilterProvider)EpisodesView.this.episodesFilter);
                } else {
                    ObjectFilterRegistry.getInstance().registerObjectFilter(Konsultation.class, (ObjectFilterRegistry.IObjectFilterProvider)EpisodesView.this.episodesFilter);
                    IcpcEpisode ep = EpisodesView.this.display.getSelectedEpisode();
                    EpisodesView.this.episodesFilter.setProblem(ep);
                }
            }
        };
    }

    public void activateKonsFilterAction(boolean bActivate) {
        this.konsFilterAction.setChecked(bActivate);
    }
}

