/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.views;

import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.elexis.icpc.model.icpc.IcpcEncounter;
import ch.elexis.icpc.views.ICPCCodesView;
import ch.rgw.tools.ExHandler;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;

public class EncounterDisplay
extends Composite {
    Form form = UiDesk.getToolkit().createForm((Composite)this);
    Group gRfe;
    Group gDiag;
    Group gProc;
    Label lRfe;
    Label lDiag;
    Label lProc;
    IcpcEncounter actEncounter;
    GenericObjectDropTarget podRfe;
    GenericObjectDropTarget podDiag;
    GenericObjectDropTarget podProc;

    public EncounterDisplay(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.gRfe = new Group(body, 0);
        this.gRfe.setText("RFE / Problem");
        GridData gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true);
        gd.heightHint = 30;
        this.gRfe.setLayoutData((Object)gd);
        this.podRfe = new GenericObjectDropTarget((Control)this.gRfe, new GenericObjectDropTarget.IReceiver(){

            public void dropped(List<Object> list, DropTargetEvent e) {
                for (Object object : list) {
                    if (EncounterDisplay.this.actEncounter == null || !(object instanceof IcpcCode)) continue;
                    EncounterDisplay.this.actEncounter.setRfe((IcpcCode)object);
                    EncounterDisplay.this.setEncounter(EncounterDisplay.this.actEncounter);
                }
                CodeSelectorHandler.getInstance().removeCodeSelectorTarget();
            }

            public boolean accept(List<Object> list) {
                for (Object object : list) {
                    if (!(object instanceof IcpcCode)) continue;
                    return true;
                }
                return false;
            }
        });
        this.gRfe.setLayout((Layout)new FillLayout());
        this.gRfe.addMouseListener((MouseListener)new ClickReact(this.podRfe, "RFE"));
        this.lRfe = new Label((Composite)this.gRfe, 64);
        this.gDiag = new Group(body, 0);
        this.gDiag.setText("Diagnose");
        this.gDiag.setLayoutData((Object)GridDataFactory.copyData((GridData)gd));
        this.podDiag = new GenericObjectDropTarget((Control)this.gDiag, new GenericObjectDropTarget.IReceiver(){

            public void dropped(List<Object> list, DropTargetEvent e) {
                for (Object object : list) {
                    if (EncounterDisplay.this.actEncounter == null || !(object instanceof IcpcCode)) continue;
                    EncounterDisplay.this.actEncounter.setDiag((IcpcCode)object);
                    EncounterDisplay.this.setEncounter(EncounterDisplay.this.actEncounter);
                }
                CodeSelectorHandler.getInstance().removeCodeSelectorTarget();
            }

            public boolean accept(List<Object> list) {
                for (Object object : list) {
                    if (!(object instanceof IcpcCode)) continue;
                    return true;
                }
                return false;
            }
        });
        this.gDiag.setLayout((Layout)new FillLayout());
        this.gDiag.addMouseListener((MouseListener)new ClickReact(this.podDiag, "DG"));
        this.lDiag = new Label((Composite)this.gDiag, 64);
        this.gProc = new Group(body, 0);
        this.gProc.setText("Procedere");
        this.podProc = new GenericObjectDropTarget((Control)this.gProc, new GenericObjectDropTarget.IReceiver(){

            public void dropped(List<Object> list, DropTargetEvent e) {
                for (Object object : list) {
                    if (EncounterDisplay.this.actEncounter == null || !(object instanceof IcpcCode)) continue;
                    EncounterDisplay.this.actEncounter.setProc((IcpcCode)object);
                    EncounterDisplay.this.setEncounter(EncounterDisplay.this.actEncounter);
                }
                CodeSelectorHandler.getInstance().removeCodeSelectorTarget();
            }

            public boolean accept(List<Object> list) {
                for (Object object : list) {
                    if (!(object instanceof IcpcCode)) continue;
                    return true;
                }
                return false;
            }
        });
        this.gProc.setLayoutData((Object)GridDataFactory.copyData((GridData)gd));
        this.gProc.setLayout((Layout)new FillLayout());
        this.gProc.addMouseListener((MouseListener)new ClickReact(this.podProc, "PROC"));
        this.lProc = new Label((Composite)this.gProc, 64);
    }

    public void setEncounter(IcpcEncounter e) {
        this.actEncounter = e;
        if (e == null) {
            this.form.setText("Keine Episode gew\u00e4hlt");
            this.lRfe.setText("");
            this.lDiag.setText("");
            this.lProc.setText("");
        } else {
            this.form.setText(e.getEpisode().getLabel());
            IcpcCode rfe = e.getRfe();
            this.lRfe.setText(rfe == null ? "" : rfe.getLabel());
            IcpcCode diag = e.getDiag();
            this.lDiag.setText(diag == null ? "" : diag.getLabel());
            IcpcCode proc = e.getProc();
            this.lProc.setText(proc == null ? "" : proc.getLabel());
        }
    }

    class ClickReact
    extends MouseAdapter {
        GenericObjectDropTarget pod;
        String mode;

        ClickReact(GenericObjectDropTarget pod, String mode) {
            this.pod = pod;
            this.mode = mode;
        }

        public void mouseUp(MouseEvent arg0) {
            try {
                ICPCCodesView cov = (ICPCCodesView)Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.icpc.codesView");
                CodeSelectorHandler.getInstance().setCodeSelectorTarget((ICodeSelectorTarget)this.pod);
                cov.setComponent(this.mode);
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
            super.mouseUp(arg0);
        }
    }
}

