/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.views;

import ch.elexis.core.data.interfaces.IDiagnose;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.util.GenericObjectDragSource;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.icpc.Messages;
import ch.elexis.icpc.model.icpc.IcpcEpisode;
import ch.elexis.icpc.model.icpc.IcpcPackage;
import ch.elexis.icpc.service.IcpcModelServiceHolder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class EpisodesDisplay
extends Composite {
    ScrolledForm form;
    IPatient actPatient;
    TreeViewer tvEpisodes;

    public EpisodesDisplay(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.form = UiDesk.getToolkit().createScrolledForm((Composite)this);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.tvEpisodes = new TreeViewer(body);
        this.tvEpisodes.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tvEpisodes.setLabelProvider((IBaseLabelProvider)new EpisodesLabelProvider());
        this.tvEpisodes.setContentProvider((IContentProvider)new EpisodecontentProvider());
        this.tvEpisodes.addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        new GenericObjectDragSource((StructuredViewer)this.tvEpisodes);
        new GenericObjectDropTarget(this.tvEpisodes.getControl(), (GenericObjectDropTarget.IReceiver)new Receiver());
        this.setPatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    public void setPatient(IPatient pat) {
        this.actPatient = pat;
        if (pat != null) {
            this.tvEpisodes.setInput((Object)pat);
        }
        this.tvEpisodes.refresh();
    }

    public IcpcEpisode getSelectedEpisode() {
        TreeItem f;
        Tree widget = this.tvEpisodes.getTree();
        TreeItem[] sel = widget.getSelection();
        if (sel == null || sel.length == 0) {
            return null;
        }
        TreeItem p = f = sel[0];
        while ((p = (f = p).getParentItem()) != null) {
        }
        return this.getEpisodeFromItem(f);
    }

    private IcpcEpisode getEpisodeFromItem(TreeItem t) {
        String etext = t.getText();
        Object[] objectArray = ((ITreeContentProvider)this.tvEpisodes.getContentProvider()).getElements((Object)this.actPatient);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IcpcEpisode ep;
            Object o = objectArray[n2];
            if (o instanceof IcpcEpisode && (ep = (IcpcEpisode)o).getLabel().equals(etext)) {
                return ep;
            }
            ++n2;
        }
        return null;
    }

    class EpisodecontentProvider
    implements ITreeContentProvider {
        EpisodecontentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IcpcEpisode) {
                IcpcEpisode ep = (IcpcEpisode)parentElement;
                ArrayList<CallSite> ret = new ArrayList<CallSite>();
                ret.add((CallSite)((Object)("Seit: " + ep.getStartDate())));
                ret.add((CallSite)((Object)("Status: " + Messages.getStatusText(ep.getStatus()))));
                List diags = ep.getDiagnosis();
                for (IDiagnosis dg : diags) {
                    ret.add((CallSite)((Object)(dg.getCodeSystemName() + ": " + dg.getLabel())));
                }
                return ret.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IcpcEpisode;
        }

        public Object[] getElements(Object inputElement) {
            if (EpisodesDisplay.this.actPatient != null) {
                IQuery query = IcpcModelServiceHolder.get().getQuery(IcpcEpisode.class);
                query.and((EStructuralFeature)IcpcPackage.Literals.ICPC_EPISODE__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)EpisodesDisplay.this.actPatient);
                query.orderBy((EStructuralFeature)IcpcPackage.Literals.ICPC_EPISODE__START_DATE, IQuery.ORDER.ASC);
                return query.execute().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class EpisodesLabelProvider
    extends LabelProvider
    implements IColorProvider {
        EpisodesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IcpcEpisode) {
                return ((IcpcEpisode)element).getLabel();
            }
            if (element instanceof String) {
                return element.toString();
            }
            return super.getText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            IcpcEpisode e;
            if (element instanceof IcpcEpisode && (e = (IcpcEpisode)element).getStatus() == 0) {
                return UiDesk.getColor((String)"hellgrau");
            }
            return UiDesk.getColor((String)"schwarz");
        }
    }

    class Receiver
    implements GenericObjectDropTarget.IReceiver {
        Receiver() {
        }

        public void dropped(List<Object> list, DropTargetEvent e) {
            IcpcEpisode hit;
            Point point;
            Tree tree = EpisodesDisplay.this.tvEpisodes.getTree();
            TreeItem item = tree.getItem(point = tree.toControl(e.x, e.y));
            if (item != null && (hit = EpisodesDisplay.this.getEpisodeFromItem(item)) != null) {
                for (Object object : list) {
                    if (object instanceof IDiagnosis) {
                        IDiagnosis id = (IDiagnosis)object;
                        hit.addDiagnosis(id);
                    }
                    EpisodesDisplay.this.tvEpisodes.refresh();
                }
            }
        }

        public boolean accept(List<Object> list) {
            for (Object object : list) {
                if (!(object instanceof IDiagnose)) continue;
                return true;
            }
            return false;
        }
    }
}

