/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.icpc.model.icpc.IcpcEncounter;
import ch.elexis.icpc.model.icpc.IcpcEpisode;
import ch.elexis.icpc.service.IcpcModelServiceHolder;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyleRange;

public class KonsExtension
implements IKonsExtension {
    IRichTextDisplay mine;
    static final String EPISODE_TITLE = "Problem: ";

    public String connect(IRichTextDisplay tf) {
        this.mine = tf;
        this.mine.addDropReceiver(IcpcEpisode.class, (IKonsExtension)this);
        return "ch.elexis.icpc";
    }

    public boolean doLayout(StyleRange n, String provider, String id) {
        n.background = UiDesk.getColor((String)"gruen");
        return true;
    }

    public boolean doXRef(String refProvider, String refID) {
        IcpcEncounter enc = IcpcModelServiceHolder.get().load(refID, IcpcEncounter.class).orElse(null);
        if (enc != null) {
            ContextServiceHolder.get().getRootContext().setTyped((Object)enc);
        }
        return true;
    }

    public IAction[] getActions() {
        return null;
    }

    public void insert(Object o, int pos) {
        if (o instanceof IcpcEpisode) {
            IcpcEpisode ep = (IcpcEpisode)o;
            IEncounter encounter = ContextServiceHolder.get().getTyped(IEncounter.class).orElse(null);
            if (encounter != null) {
                IcpcEncounter icpcEncounter = (IcpcEncounter)IcpcModelServiceHolder.get().create(IcpcEncounter.class);
                icpcEncounter.setEncounter(encounter);
                icpcEncounter.setEpisode(ep);
                IcpcModelServiceHolder.get().save((Identifiable)icpcEncounter);
                List diags = ep.getDiagnosis();
                for (IDiagnosis dg : diags) {
                    encounter.addDiagnosis(dg);
                }
                this.mine.insertXRef(pos, EPISODE_TITLE + ep.getLabel(), "ch.elexis.icpc", icpcEncounter.getId());
                EncounterServiceHolder.get().updateVersionedEntry(encounter, new Samdas(this.mine.getContentsAsXML()));
                CoreModelServiceHolder.get().save((Identifiable)encounter);
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)encounter);
            }
        }
    }

    public void removeXRef(String refProvider, String refID) {
        IcpcEncounter enc = IcpcModelServiceHolder.get().load(refID, IcpcEncounter.class).orElse(null);
        if (enc != null) {
            IcpcModelServiceHolder.get().delete((Deleteable)enc);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

