/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.views;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.icpc.Messages;
import ch.elexis.icpc.model.icpc.IcpcEpisode;
import ch.elexis.icpc.service.IcpcModelServiceHolder;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditEpisodeDialog
extends TitleAreaDialog {
    private static final int ACTIVE_INDEX = 0;
    private static final int INACTIVE_INDEX = 1;
    private IcpcEpisode episode;
    private Text tStartDate;
    private Text tTitle;
    private Text tNumber;
    private Combo cStatus;

    public EditEpisodeDialog(Shell parentShell, IcpcEpisode episode) {
        super(parentShell);
        this.episode = episode;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout(2, false));
        new Label(ret, 0).setText(Messages.StartDate);
        this.tStartDate = new Text(ret, 0);
        this.tStartDate.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.Title);
        this.tTitle = new Text(ret, 0);
        this.tTitle.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.Number);
        this.tNumber = new Text(ret, 0);
        this.tNumber.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.Status);
        this.cStatus = new Combo(ret, 4);
        this.cStatus.add(Messages.Active);
        this.cStatus.add(Messages.Inactive);
        this.initialize();
        return ret;
    }

    private void initialize() {
        if (this.episode == null) {
            this.cStatus.select(0);
        } else {
            String startDate = this.episode.getStartDate();
            String title = this.episode.getTitle();
            String number = this.episode.getNumber();
            int status = this.episode.getStatus();
            this.tStartDate.setText(startDate);
            this.tTitle.setText(title);
            this.tNumber.setText(number);
            if (status == 1) {
                this.cStatus.select(0);
            } else {
                this.cStatus.select(1);
            }
        }
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.EpisodeEditDialog_Title);
        if (this.episode == null) {
            this.setTitle(Messages.EpisodeEditDialog_Create);
        } else {
            this.setTitle(Messages.EpisodeEditDialog_Edit);
        }
        this.setMessage(Messages.EpisodeEditDialog_EnterData);
        this.setTitleImage(Images.IMG_LOGO.getImage());
    }

    protected void okPressed() {
        String startDate = this.tStartDate.getText();
        String title = this.tTitle.getText();
        String number = this.tNumber.getText();
        int status = this.cStatus.getSelectionIndex() == 0 ? 1 : 0;
        if (this.episode == null) {
            IPatient actPatient = ContextServiceHolder.get().getActivePatient().orElse(null);
            if (actPatient != null) {
                this.episode = (IcpcEpisode)IcpcModelServiceHolder.get().create(IcpcEpisode.class);
                this.episode.setPatient(actPatient);
                this.episode.setTitle(title);
                this.episode.setStartDate(startDate);
                this.episode.setNumber(number);
                this.episode.setStatus(status);
                IcpcModelServiceHolder.get().save((Identifiable)this.episode);
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)this.episode);
            }
        } else {
            this.episode.setTitle(title);
            this.episode.setStartDate(startDate);
            this.episode.setNumber(number);
            this.episode.setStatus(status);
            IcpcModelServiceHolder.get().save((Identifiable)this.episode);
            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)this.episode);
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

