/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc;

import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IQuery;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.icpc.Messages;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.elexis.icpc.model.icpc.IcpcEncounter;
import ch.elexis.icpc.model.icpc.IcpcEpisode;
import ch.elexis.icpc.model.icpc.IcpcPackage;
import ch.elexis.icpc.service.IcpcModelServiceHolder;
import ch.rgw.tools.Result;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DataAccessor
implements IDataAccess {
    public String getName() {
        return "ICPC2-Daten";
    }

    public String getDescription() {
        return "Daten aus dem ICPC2-Plugin";
    }

    public List<IDataAccess.Element> getList() {
        return null;
    }

    private String code(IcpcCode ic) {
        return ic == null ? "" : ic.getCode();
    }

    private Result<Object> sucheEncounters(IcpcEpisode ep, String dates, Object dep) {
        IQuery query = IcpcModelServiceHolder.get().getQuery(IcpcEncounter.class);
        query.and((EStructuralFeature)IcpcPackage.Literals.ICPC_ENCOUNTER__EPISODE, IQuery.COMPARATOR.EQUALS, (Object)ep);
        if (dep instanceof Konsultation) {
            IEncounter encounter = CoreModelServiceHolder.get().load(((Konsultation)dep).getId(), IEncounter.class).orElse(null);
            query.and((EStructuralFeature)IcpcPackage.Literals.ICPC_ENCOUNTER__ENCOUNTER, IQuery.COMPARATOR.EQUALS, (Object)encounter);
        }
        List encounters = query.execute();
        encounters = encounters.parallelStream().filter(e -> this.filterEmptyEncounter((IcpcEncounter)e)).collect(Collectors.toList());
        Collections.sort(encounters, new Comparator<IcpcEncounter>(){

            @Override
            public int compare(IcpcEncounter e1, IcpcEncounter e2) {
                return e1.getEncounter().getDate().compareTo(e2.getEncounter().getDate());
            }
        });
        return new Result(encounters);
    }

    private boolean filterEmptyEncounter(IcpcEncounter encounter) {
        return encounter.getRfe() != null || encounter.getDiag() != null || encounter.getProc() != null;
    }

    private Result<Object> sucheEncounters(List<IcpcEpisode> eps, Map<IcpcEpisode, List<IcpcEncounter>> encs, Object dep, String dates) {
        IPatient pat;
        if (dep instanceof Konsultation) {
            IEncounter encounter = CoreModelServiceHolder.get().load(((Konsultation)dep).getId(), IEncounter.class).orElse(null);
            pat = encounter.getPatient();
        } else if (dep instanceof Patient) {
            pat = CoreModelServiceHolder.get().load(((Patient)dep).getId(), IPatient.class).orElse(null);
        } else {
            return new Result(Result.SEVERITY.ERROR, 1, "Ung\u00fcltiger Parameter", dep, true);
        }
        IQuery query = IcpcModelServiceHolder.get().getQuery(IcpcEpisode.class);
        query.and((EStructuralFeature)IcpcPackage.Literals.ICPC_EPISODE__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)pat);
        query.orderBy((EStructuralFeature)IcpcPackage.Literals.ICPC_EPISODE__START_DATE, IQuery.ORDER.ASC);
        List raw_eps = query.execute();
        int count = 0;
        for (IcpcEpisode ep : raw_eps) {
            Result<Object> res = this.sucheEncounters(ep, dates, dep);
            if (!res.isOK()) {
                return res;
            }
            List ep_encs = (List)res.get();
            if (ep_encs.size() <= 0) continue;
            eps.add(ep);
            encs.put(ep, ep_encs);
            count += 1 + ep_encs.size();
        }
        return new Result((Object)count);
    }

    public Result<Object> getObject(String descriptor, PersistentObject dependentObject, String dates, String[] params) {
        if (descriptor.toLowerCase().equals("encounters")) {
            LinkedList<IcpcEpisode> episodes = new LinkedList<IcpcEpisode>();
            HashMap<IcpcEpisode, List<IcpcEncounter>> encounters = new HashMap<IcpcEpisode, List<IcpcEncounter>>();
            Result<Object> res = this.sucheEncounters(episodes, encounters, dependentObject, dates);
            if (!res.isOK()) {
                return res;
            }
            int rows = (Integer)res.get() + 1;
            String[][] result = new String[rows][5];
            int i = 0;
            result[i][0] = "Problem";
            result[i][1] = "Datum";
            result[i][2] = "RFE";
            result[i][3] = "Diagnose";
            result[i][4] = "Procedere";
            ++i;
            for (IcpcEpisode ep : episodes) {
                result[i][0] = ep.getTitle();
                result[i][1] = ep.getStartDate();
                result[i][2] = this.getStatusText(ep.getStatus());
                result[i][4] = "";
                result[i][3] = "";
                ++i;
                for (IcpcEncounter en : encounters.get(ep)) {
                    result[i][0] = "";
                    result[i][1] = en.getEncounter().getDate().format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
                    result[i][2] = this.code(en.getRfe());
                    result[i][3] = this.code(en.getDiag());
                    result[i][4] = this.code(en.getProc());
                    ++i;
                }
            }
            return new Result((Object)result);
        }
        return new Result(Result.SEVERITY.ERROR, 2, "Ung\u00fcltiger Parameter", (Object)descriptor, true);
    }

    private String getStatusText(int status) {
        if (status == 1) {
            return Messages.Active;
        }
        return Messages.Inactive;
    }
}

