/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.model.internal;

import ch.elexis.core.jpa.entities.Behandlung;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.ICPCEncounter;
import ch.elexis.core.jpa.entities.ICPCEpisode;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.elexis.icpc.model.icpc.IcpcEncounter;
import ch.elexis.icpc.model.icpc.IcpcEpisode;
import ch.elexis.icpc.model.internal.service.IcpcModelServiceHolder;
import org.apache.commons.lang3.StringUtils;

public class Encounter
extends AbstractIdModelAdapter<ICPCEncounter>
implements Identifiable,
IcpcEncounter {
    public Encounter(ICPCEncounter entity) {
        super((EntityWithId)entity);
    }

    public boolean isDeleted() {
        return ((ICPCEncounter)this.getEntity()).isDeleted();
    }

    public void setDeleted(boolean value) {
        ((ICPCEncounter)this.getEntityMarkDirty()).setDeleted(value);
    }

    @Override
    public IEncounter getEncounter() {
        return CoreModelServiceHolder.get().adapt((Object)((ICPCEncounter)this.getEntity()).getKons(), IEncounter.class).orElse(null);
    }

    @Override
    public void setEncounter(IEncounter value) {
        if (value != null) {
            ((ICPCEncounter)this.getEntityMarkDirty()).setKons((Behandlung)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((ICPCEncounter)this.getEntityMarkDirty()).setKons(null);
        }
    }

    @Override
    public IcpcEpisode getEpisode() {
        return IcpcModelServiceHolder.get().adapt((Object)((ICPCEncounter)this.getEntity()).getEpisode(), IcpcEpisode.class).orElse(null);
    }

    @Override
    public void setEpisode(IcpcEpisode value) {
        if (value != null) {
            ((ICPCEncounter)this.getEntityMarkDirty()).setEpisode((ICPCEpisode)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((ICPCEncounter)this.getEntityMarkDirty()).setEpisode(null);
        }
    }

    @Override
    public IcpcCode getProc() {
        String codeId = ((ICPCEncounter)this.getEntity()).getProc();
        if (!StringUtils.isBlank((CharSequence)codeId)) {
            return IcpcModelServiceHolder.get().load(codeId, IcpcCode.class).orElse(null);
        }
        return null;
    }

    @Override
    public void setProc(IcpcCode value) {
        if (value != null) {
            ((ICPCEncounter)this.getEntityMarkDirty()).setProc(value.getId());
        } else {
            ((ICPCEncounter)this.getEntityMarkDirty()).setProc(null);
        }
    }

    @Override
    public IcpcCode getDiag() {
        String codeId = ((ICPCEncounter)this.getEntity()).getDiag();
        if (!StringUtils.isBlank((CharSequence)codeId)) {
            return IcpcModelServiceHolder.get().load(codeId, IcpcCode.class).orElse(null);
        }
        return null;
    }

    @Override
    public void setDiag(IcpcCode value) {
        if (value != null) {
            ((ICPCEncounter)this.getEntityMarkDirty()).setDiag(value.getId());
        } else {
            ((ICPCEncounter)this.getEntityMarkDirty()).setDiag(null);
        }
    }

    @Override
    public IcpcCode getRfe() {
        String codeId = ((ICPCEncounter)this.getEntity()).getRfe();
        if (!StringUtils.isBlank((CharSequence)codeId)) {
            return IcpcModelServiceHolder.get().load(codeId, IcpcCode.class).orElse(null);
        }
        return null;
    }

    @Override
    public void setRfe(IcpcCode value) {
        if (value != null) {
            ((ICPCEncounter)this.getEntityMarkDirty()).setRfe(value.getId());
        } else {
            ((ICPCEncounter)this.getEntityMarkDirty()).setRfe(null);
        }
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }
}

