/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.model.internal.service;

import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IQuery;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.elexis.icpc.model.internal.Code;
import ch.elexis.icpc.model.internal.service.IcpcModelServiceHolder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;

@Component
public class CodeElementContribution
implements ICodeElementServiceContribution {
    public String getSystem() {
        return "ICPC";
    }

    public ICodeElementService.CodeElementTyp getTyp() {
        return ICodeElementService.CodeElementTyp.DIAGNOSE;
    }

    public Optional<ICodeElement> loadFromCode(String code, Map<Object, Object> context) {
        return IcpcModelServiceHolder.get().load(code, IcpcCode.class);
    }

    public List<ICodeElement> getElements(Map<Object, Object> context) {
        if (context.get(ICodeElementService.ContextKeys.TREE_ROOTS) != null && context.get(ICodeElementService.ContextKeys.TREE_ROOTS).equals(Boolean.TRUE)) {
            return Code.getRootCodes();
        }
        IQuery query = IcpcModelServiceHolder.get().getQuery(IcpcCode.class);
        query.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"ver");
        return query.execute();
    }
}

