/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.model.internal;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.ICPCEpisode;
import ch.elexis.core.jpa.entities.ICPCEpisodeDiagnosisLink;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.icpc.model.icpc.IcpcEpisode;
import ch.elexis.icpc.model.internal.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Episode
extends AbstractIdModelAdapter<ICPCEpisode>
implements Identifiable,
IcpcEpisode {
    public Episode(ICPCEpisode entity) {
        super((EntityWithId)entity);
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public boolean isDeleted() {
        return ((ICPCEpisode)this.getEntity()).isDeleted();
    }

    public void setDeleted(boolean value) {
        ((ICPCEpisode)this.getEntity()).setDeleted(value);
    }

    @Override
    public String getTitle() {
        return ((ICPCEpisode)this.getEntity()).getTitle();
    }

    @Override
    public void setTitle(String value) {
        ((ICPCEpisode)this.getEntity()).setTitle(value);
    }

    @Override
    public String getNumber() {
        return ((ICPCEpisode)this.getEntity()).getNumber();
    }

    @Override
    public void setNumber(String value) {
        ((ICPCEpisode)this.getEntity()).setNumber(value);
    }

    @Override
    public int getStatus() {
        return ((ICPCEpisode)this.getEntity()).getStatus();
    }

    @Override
    public void setStatus(int value) {
        ((ICPCEpisode)this.getEntity()).setStatus(value);
    }

    @Override
    public IPatient getPatient() {
        return CoreModelServiceHolder.get().adapt((Object)((ICPCEpisode)this.getEntity()).getPatientKontakt(), IPatient.class).orElse(null);
    }

    @Override
    public void setPatient(IPatient value) {
        if (value != null) {
            ((ICPCEpisode)this.getEntity()).setPatientKontakt((Kontakt)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((ICPCEpisode)this.getEntity()).setPatientKontakt(null);
        }
    }

    @Override
    public List<IDiagnosis> getDiagnosis() {
        List links = ((ICPCEpisode)this.getEntity()).getLinks();
        ArrayList<IDiagnosis> ret = new ArrayList<IDiagnosis>();
        for (ICPCEpisodeDiagnosisLink iDiagnosisLink : links) {
            Optional loaded = StoreToStringServiceHolder.get().loadFromString(iDiagnosisLink.getDiagnosis());
            if (!loaded.isPresent() || !(loaded.get() instanceof IDiagnosis)) continue;
            ret.add((IDiagnosis)loaded.get());
        }
        return ret;
    }

    @Override
    public void addDiagnosis(IDiagnosis diagnosis) {
        Optional string = StoreToStringServiceHolder.get().storeToString((Identifiable)diagnosis);
        string.ifPresent(s -> ((ICPCEpisode)this.getEntity()).addDiagnosis(s));
    }

    @Override
    public void removeDiagnosis(IDiagnosis diagnosis) {
        Optional string = StoreToStringServiceHolder.get().storeToString((Identifiable)diagnosis);
        string.ifPresent(s -> {
            List links = ((ICPCEpisode)this.getEntity()).getLinks();
            for (ICPCEpisodeDiagnosisLink link : links) {
                if (!link.getDiagnosis().equals(string.get())) continue;
                ((ICPCEpisode)this.getEntity()).removeDiagnosis(link);
                break;
            }
        });
    }

    @Override
    public String getStartDate() {
        return ((ICPCEpisode)this.getEntity()).getStartDate();
    }

    @Override
    public void setStartDate(String value) {
        ((ICPCEpisode)this.getEntity()).setStartDate(value);
    }

    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)this.getNumber())) {
            sb.append(this.getNumber()).append(": ");
        }
        sb.append(this.getTitle());
        sb.append(" [" + (this.getStatus() == 1 ? Messages.Active : Messages.Inactive) + "]");
        return sb.toString();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }
}

