/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.model.internal.importer;

import ch.elexis.icpc.model.internal.importer.EntityManagerHolder;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import java.util.List;

public class EntityUtil {
    public static void save(List<Object> saveObject) {
        try (EntityManager em = (EntityManager)EntityManagerHolder.get().getEntityManager();){
            em.getTransaction().begin();
            for (Object object : saveObject) {
                em.merge(object);
            }
            em.getTransaction().commit();
        }
    }

    public static void removeAll(List<Object> removeObjects) {
        try (EntityManager em = (EntityManager)EntityManagerHolder.get().getEntityManager();){
            em.getTransaction().begin();
            for (Object object : removeObjects) {
                Object mergedObject = em.merge(object);
                em.remove(mergedObject);
            }
            em.getTransaction().commit();
        }
    }

    public static <T> T load(String id, Class<T> clazz) {
        try (EntityManager em = (EntityManager)EntityManagerHolder.get().getEntityManager();){
            Object object = em.find(clazz, (Object)id);
            return (T)object;
        }
    }

    public static <T> List<T> loadAll(Class<T> clazz) {
        try (EntityManager em = (EntityManager)EntityManagerHolder.get().getEntityManager();){
            CriteriaQuery criteria = em.getCriteriaBuilder().createQuery(clazz);
            criteria.select((Selection)criteria.from(clazz));
            List list = em.createQuery(criteria).getResultList();
            return list;
        }
    }
}

