/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.message.ui.handler;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.hl7.message.ui.preference.PreferenceUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MessageUtil {
    public static Map<String, Object> getContext() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        Konsultation cons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
        Mandant mandant = ElexisEventDispatcher.getSelectedMandator();
        if (patient != null) {
            ret.put("context.patient", patient);
        }
        if (cons != null) {
            ret.put("context.consultation", cons);
        }
        if (mandant != null) {
            ret.put("context.mandator", mandant);
        }
        return ret;
    }

    public static void export(String typ, String message, String encoding) throws IOException {
        Optional<File> outputDir = PreferenceUtil.getOutputDirectory();
        if (outputDir.isPresent()) {
            File outputFile = new File(outputDir.get(), System.currentTimeMillis() + "_" + typ + ".hl7");
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding));){
                writer.write(message);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

