/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.message.core.message;

import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.hl7.data.HL7Konsultation;
import ch.elexis.hl7.data.HL7Kontakt;
import ch.elexis.hl7.data.HL7Mandant;
import ch.elexis.hl7.data.HL7Patient;
import ch.rgw.tools.TimeTool;

public class HL7MessageUtil {
    public static HL7Mandant mandantOf(Mandant eMandant) {
        HL7Mandant ret = new HL7Mandant();
        ret.setLabel(eMandant.get("Label"));
        ret.setEan(eMandant.getXid("www.xid.ch/id/ean"));
        return ret;
    }

    public static HL7Patient patientOf(Patient ePatient) {
        HL7Patient ret = new HL7Patient();
        HL7MessageUtil.setContactInfo((HL7Kontakt)ret, (Kontakt)ePatient);
        String geschlecht = ePatient.getGeschlecht();
        if (geschlecht != null && geschlecht.length() > 0) {
            ret.setIsMale(Boolean.valueOf("m".toUpperCase().equals(ePatient.getGeschlecht().toUpperCase())));
        }
        ret.setBirthdate(new TimeTool(ePatient.getGeburtsdatum()).getTime());
        ret.setPatCode(ePatient.getPatCode());
        return ret;
    }

    public static HL7Konsultation consultationOf(Konsultation eConsultation) {
        HL7Konsultation ret = new HL7Konsultation();
        ret.setId(eConsultation.getId());
        TimeTool timeTool = new TimeTool(eConsultation.getDatum());
        ret.setZeitpunkt(timeTool.toLocalDateTime());
        return ret;
    }

    private static void setContactInfo(HL7Kontakt hKontakt, Kontakt eKontakt) {
        String name = eKontakt.get("Bezeichnung1");
        if (name == null) {
            name = "";
        }
        hKontakt.setName(name.trim());
        String firstname = eKontakt.get("Bezeichnung2");
        if (firstname == null) {
            firstname = "";
        }
        hKontakt.setFirstname(firstname.trim());
        String title = eKontakt.get("Titel");
        if (title == null) {
            title = "";
        }
        hKontakt.setTitle(title.trim());
        String phone1 = eKontakt.get("Telefon1");
        if (phone1 == null) {
            phone1 = "";
        }
        hKontakt.setPhone1(phone1.trim());
        String phone2 = eKontakt.get("Telefon2");
        if (phone2 == null) {
            phone2 = "";
        }
        hKontakt.setPhone2(phone2.trim());
        String email = eKontakt.get("E-Mail");
        if (email == null) {
            email = "";
        }
        hKontakt.setEmail(email.trim());
        String fax = eKontakt.get("Fax");
        if (fax == null) {
            fax = "";
        }
        hKontakt.setFax(fax.trim());
        String street = eKontakt.get("Strasse");
        if (street == null) {
            street = "";
        }
        hKontakt.setAddress1(street.trim());
        String other = eKontakt.get("Bezeichnung3");
        if (other == null) {
            other = "";
        }
        hKontakt.setAddress2(other.trim());
        String city = eKontakt.get("Ort");
        if (city == null) {
            city = "";
        }
        hKontakt.setCity(city.trim());
        String zip = eKontakt.get("Plz");
        if (zip == null) {
            zip = "";
        }
        hKontakt.setZip(zip.trim());
        String country = eKontakt.get("Land");
        if (country == null) {
            country = "";
        }
        hKontakt.setCountry(country.trim());
    }
}

