/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.ui.parts;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.global_inbox.model.GlobalInboxEntry;
import ch.elexis.global_inbox.ui.Messages;
import ch.elexis.global_inbox.ui.parts.FileDocument;
import ch.elexis.global_inbox.ui.parts.GlobalInboxContentProvider;
import ch.elexis.global_inbox.ui.parts.GlobalInboxLabelProvider;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.slf4j.LoggerFactory;

public class GlobalInboxPart {
    private TableViewer tv;
    private String[] columnHeaders = new String[]{Messages.InboxView_category, Messages.InboxView_title};
    private TableColumn[] tc;
    private IStatus inboxConfigStat;
    private boolean configErrorShown = false;
    private GlobalInboxContentProvider cp;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;

    @Inject
    public GlobalInboxPart(Composite parent, EMenuService menuService, ESelectionService selectionService, IEventBroker eventBroker) {
        Table table = new Table(parent, 65536);
        this.tv = new TableViewer(table);
        this.tc = new TableColumn[this.columnHeaders.length];
        int i = 0;
        while (i < this.tc.length) {
            this.tc[i] = new TableColumn(table, 0);
            this.tc[i].setText(this.columnHeaders[i]);
            if (i == 0) {
                this.tc[i].setWidth(100);
            } else {
                this.tc[i].setWidth(250);
            }
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.cp = new GlobalInboxContentProvider(this);
        this.tv.setContentProvider((IContentProvider)this.cp);
        this.tv.setLabelProvider((IBaseLabelProvider)new GlobalInboxLabelProvider());
        this.tv.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                GlobalInboxEntry f1 = (GlobalInboxEntry)e1;
                GlobalInboxEntry f2 = (GlobalInboxEntry)e2;
                return f1.getMainFile().getName().toLowerCase().compareTo(f2.getMainFile().getName().toLowerCase());
            }
        });
        this.tv.addSelectionChangedListener(event -> {
            GlobalInboxEntry globalInboxEntry = (GlobalInboxEntry)this.tv.getStructuredSelection().getFirstElement();
            selectionService.setSelection((Object)globalInboxEntry);
            if (globalInboxEntry != null) {
                File mainFile = globalInboxEntry.getPdfPreviewFile();
                try {
                    FileDocument mainFileDocument = FileDocument.of(mainFile);
                    eventBroker.post("ui/preview/mimetype/application/pdf", (Object)mainFileDocument);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("Exception", (Throwable)e);
                }
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ParameterizedCommand command = GlobalInboxPart.this.commandService.createCommand("ch.elexis.global_inbox.command.globalinboxentryview");
                GlobalInboxPart.this.handlerService.executeHandler(command);
            }
        });
        this.inboxConfigStat = this.cp.reload();
        menuService.registerContextMenu((Object)table, "ch.elexis.global_inbox.popupmenu.globalinboxentries");
        this.tv.setInput((Object)this);
    }

    @Inject
    @Optional
    void handleRemoveAndSelectNext(@UIEventTopic(value="ui/globalinboxentry/removeandselectnext") GlobalInboxEntry gie) {
        int selectionIndex = this.tv.getTable().getSelectionIndex();
        this.tv.remove((Object)gie);
        this.tv.getTable().setSelection(selectionIndex);
    }

    @PreDestroy
    public void destroy() {
        this.cp.destroy();
    }

    @Focus
    public void setFocus() {
        if (!this.inboxConfigStat.isOK() && !this.configErrorShown) {
            SWTHelper.alert((String)Messages.Activator_noInbox, (String)Messages.InboxContentProvider_noInboxDefined);
            this.configErrorShown = true;
        }
    }

    public void reload() {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GlobalInboxPart.this.tv != null && GlobalInboxPart.this.tv.getControl() != null && !GlobalInboxPart.this.tv.getControl().isDisposed()) {
                    GlobalInboxPart.this.tv.refresh();
                }
            }
        });
    }

    public void reloadInbox() {
        IStatus status = this.cp.reload();
        if (status == Status.CANCEL_STATUS) {
            SWTHelper.showError((String)Messages.InboxView_error, (String)Messages.InvoxView_errorCantDetectInbox);
        }
    }
}

