/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.ui.parts;

import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.data.util.LocalLock;
import ch.elexis.core.rcp.utils.OsgiServiceUtil;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.util.viewers.CommonContentProviderAdapter;
import ch.elexis.global_inbox.internal.service.GlobalInboxEntryFactory;
import ch.elexis.global_inbox.model.GlobalInboxEntry;
import ch.elexis.global_inbox.ui.GlobalInboxUtil;
import ch.elexis.global_inbox.ui.parts.GlobalInboxPart;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalInboxContentProvider
extends CommonContentProviderAdapter {
    private static final String LOCAL_LOCK_INBOXIMPORT = "GlobalInboxImport";
    private final Pattern PATIENT_MATCH_PATTERN = Pattern.compile("([0-9]+)_(.+)");
    private Logger log;
    private List<GlobalInboxEntry> entries;
    private List<GlobalInboxEntry> loadJobList;
    private GlobalInboxPart view;
    private LoadJob loader;
    private GlobalInboxUtil giutil;
    private GlobalInboxEntryFactory globalInboxEntryFactory;

    public void dispose() {
        super.dispose();
    }

    public IStatus reload() {
        return this.loader.run(null);
    }

    public GlobalInboxContentProvider(GlobalInboxPart view) {
        this.view = view;
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.entries = new ArrayList<GlobalInboxEntry>();
        this.loadJobList = new ArrayList<GlobalInboxEntry>();
        this.loader = new LoadJob();
        this.loader.schedule(1000L);
        this.giutil = new GlobalInboxUtil();
        this.globalInboxEntryFactory = (GlobalInboxEntryFactory)OsgiServiceUtil.getServiceWait(GlobalInboxEntryFactory.class, (long)5000L).orElseThrow(() -> new IllegalStateException("No GlobalInboxEntryFactory"));
    }

    public Object[] getElements(Object inputElement) {
        return this.entries == null ? null : this.entries.toArray();
    }

    void destroy() {
        this.giutil = null;
        this.entries = null;
        this.loader.cancel();
        this.loader = null;
    }

    class LoadJob
    extends Job {
        public LoadJob() {
            super("GlobalInbox");
            this.setPriority(50);
            this.setUser(false);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            LocalLock lock = new LocalLock((Object)GlobalInboxContentProvider.LOCAL_LOCK_INBOXIMPORT);
            if (lock.tryLock()) {
                String filepath = GlobalInboxUtil.getDirectory(null, null);
                File dir = null;
                if (filepath == null) {
                    filepath = "";
                    ConfigServiceHolder.get().setLocal("plugins/global_inbox/dir", "");
                }
                if (!(dir = new File(filepath)).isDirectory()) {
                    if (GlobalInboxContentProvider.this.view != null) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
                Object dm = Extensions.findBestService((String)"DocumentManagement");
                if (dm == null) {
                    GlobalInboxContentProvider.this.log.warn("No document management service found.");
                    return Status.OK_STATUS;
                }
                IDocumentManager documentManager = (IDocumentManager)dm;
                String[] cats = documentManager.getCategories();
                if (cats != null) {
                    String[] stringArray = cats;
                    int n = cats.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String cat = stringArray[n2];
                        File subdir = new File(dir, cat);
                        if (!subdir.exists()) {
                            subdir.mkdirs();
                        }
                        ++n2;
                    }
                }
                GlobalInboxContentProvider.this.loadJobList.clear();
                this.addFilesInDirRecursive(dir);
                this.filterAndPopulate();
                if (GlobalInboxContentProvider.this.view != null) {
                    GlobalInboxContentProvider.this.view.reload();
                }
                this.schedule(120000L);
            } else {
                GlobalInboxContentProvider.this.log.info("Skipping document import, lock present.");
                long lockMillis = lock.getLockCurrentMillis();
                if (lockMillis == -1L || System.currentTimeMillis() - lockMillis > 240000L) {
                    GlobalInboxContentProvider.this.log.warn("Removing pending lock " + lock.getLockMessage() + "@" + lockMillis);
                    lock.unlock();
                }
            }
            LocalLock.getManagedLock((Object)GlobalInboxContentProvider.LOCAL_LOCK_INBOXIMPORT).ifPresent(localDocumentLock -> localDocumentLock.unlock());
            return Status.OK_STATUS;
        }

        private void filterAndPopulate() {
            Iterator<GlobalInboxEntry> iterator = GlobalInboxContentProvider.this.entries.iterator();
            while (iterator.hasNext()) {
                GlobalInboxEntry gie = iterator.next();
                if (GlobalInboxContentProvider.this.loadJobList.contains(gie)) continue;
                iterator.remove();
            }
            for (GlobalInboxEntry gie : GlobalInboxContentProvider.this.loadJobList) {
                if (GlobalInboxContentProvider.this.entries.contains(gie)) continue;
                gie = GlobalInboxContentProvider.this.globalInboxEntryFactory.populateExtensionInformation(gie);
                GlobalInboxContentProvider.this.entries.add(gie);
            }
        }

        private void addFilesInDirRecursive(File dir) {
            ArrayList<String> allFilesInDirRecursive = new ArrayList<String>();
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isHidden() && !file.getName().startsWith(".")) {
                    if (file.isDirectory()) {
                        this.addFilesInDirRecursive(file);
                    } else {
                        allFilesInDirRecursive.add(file.getAbsolutePath());
                    }
                    if (file.isDirectory()) {
                        this.addFilesInDirRecursive(file);
                    } else {
                        String fileName;
                        String patientNo;
                        String tryImportForPatient;
                        Matcher matcher = GlobalInboxContentProvider.this.PATIENT_MATCH_PATTERN.matcher(file.getName());
                        if (matcher.matches() && (tryImportForPatient = GlobalInboxContentProvider.this.giutil.tryImportForPatient(file, patientNo = matcher.group(1), fileName = matcher.group(2))) != null) {
                            GlobalInboxContentProvider.this.log.info("Auto imported file [{}], document id is [{}]", (Object)file, (Object)tryImportForPatient);
                        } else {
                            allFilesInDirRecursive.add(file.getAbsolutePath());
                        }
                    }
                }
                ++n2;
            }
            allFilesInDirRecursive.sort(Comparator.comparingInt(String::length));
            ArrayList<File> extensionFiles = new ArrayList<File>();
            for (String string : allFilesInDirRecursive) {
                File file = new File(string);
                if (extensionFiles.contains(file)) continue;
                File[] _extensionFiles = dir.listFiles((_dir, _name) -> _name.startsWith(file.getName()) && !Objects.equals(_name, file.getName()));
                extensionFiles.addAll(Arrays.asList(_extensionFiles));
                GlobalInboxEntry globalInboxEntry = GlobalInboxContentProvider.this.globalInboxEntryFactory.createEntry(file, _extensionFiles);
                GlobalInboxContentProvider.this.loadJobList.add(globalInboxEntry);
            }
        }
    }
}

