/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.ui.handler;

import at.medevit.elexis.inbox.model.IInboxElementService;
import ch.elexis.core.documents.DocumentStore;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IDocumentReference;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.global_inbox.model.GlobalInboxEntry;
import ch.elexis.global_inbox.ui.GlobalInboxUtil;
import ch.elexis.omnivore.data.AutomaticBilling;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.LoggerFactory;

public class GlobalInboxEntryImportHandler {
    @Inject
    private IConfigService configService;
    @Inject
    private IContextService contextService;
    @Inject
    private DocumentStore documentStore;
    @Inject
    private IFindingsService findingService;
    @Inject
    private IInboxElementService inboxElementService;

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") GlobalInboxEntry globalInboxEntry, IEventBroker eventBroker) {
        String title = globalInboxEntry.getTitle();
        IPatient patient = globalInboxEntry.getPatient();
        if (patient == null) {
            patient = this.contextService.getActivePatient().orElse(null);
        }
        IContact sender = globalInboxEntry.getSender();
        ICategory category = this.getCategoryOrDefault(globalInboxEntry.getCategory());
        File mainFile = globalInboxEntry.getMainFile();
        IDocument document = this.documentStore.createDocument(null, patient.getId(), mainFile.getName(), category.getName());
        document.setTitle(title);
        document.setMimeType(globalInboxEntry.getMimetype());
        document.setKeywords(globalInboxEntry.getKeywords());
        if (globalInboxEntry.getCreationDate() != null) {
            document.setCreated(globalInboxEntry.getCreationDate());
        } else {
            document.setCreated(new Date());
        }
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileInputStream fin = new FileInputStream(mainFile);){
                document = this.documentStore.saveDocument(document, (InputStream)fin);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ElexisException | IOException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Import error", e);
            SWTHelper.showError((String)"Import error", (String)e.getMessage());
            this.documentStore.removeDocument(document);
            return;
        }
        IDocumentReference documentReference = (IDocumentReference)this.findingService.create(IDocumentReference.class);
        documentReference.setPatientId(patient.getId());
        documentReference.setAuthorId(sender != null ? sender.getId() : null);
        documentReference.setDocument(document);
        try {
            this.findingService.saveFinding((IFinding)documentReference);
        }
        catch (IllegalStateException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Import error - could not save documentReference");
            SWTHelper.showError((String)"Import error", (String)"Could not save documentReference");
            this.documentStore.removeDocument(document);
            return;
        }
        eventBroker.send("ui/preview/mimetype/application/pdf", null);
        new GlobalInboxUtil().removeFiles(globalInboxEntry);
        eventBroker.send("ui/preview/mimetype/application/pdf", (Object)document);
        boolean automaticBilling = this.configService.getLocal("plugins/global_inbox/autobilling", false);
        if (automaticBilling && AutomaticBilling.isEnabled()) {
            AutomaticBilling billing = new AutomaticBilling(document);
            billing.bill();
        }
        if (globalInboxEntry.isSendInfoTo()) {
            List<IMandator> notificationTo = globalInboxEntry.getInfoTo();
            for (IMandator mandator : notificationTo) {
                this.inboxElementService.createInboxElement(patient, mandator, (Identifiable)document);
            }
        }
        eventBroker.send("ui/globalinboxentry/removeandselectnext", (Object)globalInboxEntry);
    }

    private ICategory getCategoryOrDefault(String category) {
        IDocumentStore defaultStore = this.documentStore.getDefaultDocumentStore();
        ICategory ret = defaultStore.getCategoryDefault();
        List categories = defaultStore.getCategories();
        for (ICategory iCategory : categories) {
            if (!iCategory.getName().equals(category)) continue;
            ret = iCategory;
            break;
        }
        return ret;
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") GlobalInboxEntry globalInboxEntry) {
        if (globalInboxEntry == null) {
            return false;
        }
        if (globalInboxEntry.getPatient() == null && !this.contextService.getActivePatient().isPresent()) {
            return false;
        }
        return globalInboxEntry.getCategory() != null;
    }
}

