/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.model;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GlobalInboxEntry {
    private String title;
    private String mimetype;
    private IPatient patient;
    private IContact sender;
    private String category;
    private String keywords;
    private Date creationDate;
    private Date archivingDate;
    private boolean sendInfoTo;
    private List<IMandator> infoTo;
    private List<IPatient> patientCandidates;
    private List<IContact> senderCandidates;
    private List<LocalDate> dateTokens;
    private LocalDate creationDateCandidate;
    private final File mainFile;
    private final File[] extensionFiles;

    public GlobalInboxEntry(File mainFile, File[] extensionFiles) {
        this.mainFile = mainFile;
        this.title = mainFile.getName();
        this.extensionFiles = extensionFiles;
        this.patientCandidates = new ArrayList<IPatient>();
        this.senderCandidates = new ArrayList<IContact>();
        this.dateTokens = new ArrayList<LocalDate>();
    }

    public File getMainFile() {
        return this.mainFile;
    }

    public File[] getExtensionFiles() {
        return this.extensionFiles;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void setPatient(IPatient patient) {
        this.patient = patient;
    }

    public IContact getSender() {
        return this.sender;
    }

    public void setSender(IContact sender) {
        this.sender = sender;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setArchivingDate(Date archivingDate) {
        this.archivingDate = archivingDate;
    }

    public Date getArchivingDate() {
        return this.archivingDate;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean isSendInfoTo() {
        return this.sendInfoTo;
    }

    public void setSendInfoTo(boolean sendInfoTo) {
        this.sendInfoTo = sendInfoTo;
    }

    public List<IMandator> getInfoTo() {
        return this.infoTo;
    }

    public void setInfoTo(List<IMandator> infoTo) {
        this.infoTo = infoTo;
    }

    public List<IPatient> getPatientCandidates() {
        return this.patientCandidates;
    }

    public List<IContact> getSenderCandidates() {
        return this.senderCandidates;
    }

    public List<LocalDate> getDateTokens() {
        return this.dateTokens;
    }

    public void setPatientCandidates(List<IPatient> patientCandidates) {
        this.patientCandidates = patientCandidates;
    }

    public void setDateTokens(List<LocalDate> dateTokens) {
        this.dateTokens = dateTokens;
    }

    public void setSenderCandidates(List<IContact> senderCandidates) {
        this.senderCandidates = senderCandidates;
    }

    public void setCreationDateCandidate(LocalDate creationDateCandidate) {
        this.creationDateCandidate = creationDateCandidate;
    }

    public LocalDate getCreationDateCandidate() {
        return this.creationDateCandidate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mainFile.getAbsolutePath() == null ? 0 : this.mainFile.getAbsolutePath().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalInboxEntry other = (GlobalInboxEntry)obj;
        return !(this.mainFile.getAbsolutePath() == null ? other.mainFile.getAbsolutePath() != null : !this.mainFile.getAbsolutePath().equals(other.mainFile.getAbsolutePath()));
    }

    public File getPdfPreviewFile() {
        File[] fileArray = this.extensionFiles;
        int n = this.extensionFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File extFile = fileArray[n2];
            if (extFile.getName().endsWith(".preview.pdf")) {
                return extFile;
            }
            ++n2;
        }
        return this.getMainFile();
    }
}

