/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.preferencepage;

import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.global_inbox.preferencepage.TitleEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class CategoryEditingSupport
extends EditingSupport {
    private final TableViewer viewer;
    private final IDocumentStore omnivoreDocumentStore;
    private String[] _selectOptions;
    private List<String> categories;
    private final String NO_SELECTION = "Keine Kategorie";

    public CategoryEditingSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.omnivoreDocumentStore = OsgiServiceUtil.getService(IDocumentStore.class, (String)"(storeid=ch.elexis.data.store.omnivore)").orElse(null);
        if (this.omnivoreDocumentStore != null) {
            this.categories = this.omnivoreDocumentStore.getCategories().stream().map(category -> category.getName()).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        }
    }

    protected CellEditor getCellEditor(Object element) {
        ArrayList<String> selectOptions = new ArrayList<String>();
        selectOptions.add("Keine Kategorie");
        selectOptions.addAll(this.categories);
        this._selectOptions = selectOptions.toArray(new String[0]);
        return new ComboBoxCellEditor((Composite)this.viewer.getTable(), this._selectOptions);
    }

    protected boolean canEdit(Object element) {
        return this.omnivoreDocumentStore != null;
    }

    protected Object getValue(Object element) {
        String categoryName = ((TitleEntry)element).getCategoryName();
        if (categoryName == null) {
            return 0;
        }
        return Arrays.binarySearch(this._selectOptions, ((TitleEntry)element).getCategoryName());
    }

    protected void setValue(Object element, Object value) {
        int index = (Integer)value;
        String _value = this._selectOptions[index];
        if (_value == "Keine Kategorie") {
            ((TitleEntry)element).setCategoryName(null);
        } else {
            ((TitleEntry)element).setCategoryName(_value.toString());
        }
        this.viewer.refresh(element);
    }
}

