/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.core.strategies;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.global_inbox.core.strategies.IImportStrategy;
import ch.elexis.global_inbox.core.util.ImportOmnivoreInboxUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatientFolderStrategy
implements IImportStrategy {
    private final Pattern PATIENT_DIR_PATTERN = Pattern.compile("([0-9]+)(?:_[^0-9].*)?");
    private final ImportOmnivoreInboxUtil giutil;
    private final String deviceName;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public PatientFolderStrategy(ImportOmnivoreInboxUtil giutil, String deviceName) {
        this.giutil = giutil;
        this.deviceName = deviceName;
    }

    @Override
    public boolean importFile(IVirtualFilesystemService.IVirtualFilesystemHandle file) {
        Matcher m;
        block6: {
            IVirtualFilesystemService.IVirtualFilesystemHandle parent;
            block5: {
                parent = file.getParent();
                if (parent != null) break block5;
                return false;
            }
            m = this.PATIENT_DIR_PATTERN.matcher(parent.getName());
            if (m.matches()) break block6;
            return false;
        }
        try {
            String patientNo = m.group(1);
            String documentName = this.deviceName + "_" + file.getName();
            String tryImportForPatient = this.giutil.tryImportForPatient(file, patientNo, documentName);
            if (tryImportForPatient != null) {
                this.log.info("Auto imported (FOLDER_WITH_NAME) file [{}], document id is [{}]", (Object)file, (Object)tryImportForPatient);
                return true;
            }
        }
        catch (IOException e) {
            this.log.error("Error accessing parent folder", (Throwable)e);
        }
        return false;
    }
}

