/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.core.strategies;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.global_inbox.core.strategies.IImportStrategy;
import ch.elexis.global_inbox.core.util.ImportOmnivoreInboxUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePrefixStrategy
implements IImportStrategy {
    private final Pattern PATIENT_MATCH_PATTERN = Pattern.compile("([0-9]+)_(.+)");
    private final ImportOmnivoreInboxUtil giutil;
    private final String deviceName;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public FilePrefixStrategy(ImportOmnivoreInboxUtil giutil, String deviceName) {
        this.giutil = giutil;
        this.deviceName = deviceName;
    }

    @Override
    public boolean importFile(IVirtualFilesystemService.IVirtualFilesystemHandle file) {
        String fileName;
        String patientNo;
        String tryImportForPatient;
        Matcher matcher = this.PATIENT_MATCH_PATTERN.matcher(file.getName());
        if (matcher.matches() && (tryImportForPatient = this.giutil.tryImportForPatient(file, patientNo = matcher.group(1), fileName = this.deviceName + "_" + matcher.group(2))) != null) {
            this.log.info("Auto imported (FILE_PREFIX) file [{}], document id is [{}]", (Object)file, (Object)tryImportForPatient);
            return true;
        }
        return false;
    }
}

