/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.core.strategies;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.global_inbox.core.strategies.IImportStrategy;
import ch.elexis.global_inbox.core.util.ImportOmnivoreInboxUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyStrategy
implements IImportStrategy {
    private final Pattern PATIENT_DIR_PATTERN = Pattern.compile("([0-9]+)(?:_[^0-9].*)?");
    private final ImportOmnivoreInboxUtil giutil;
    private final String deviceName;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public HierarchyStrategy(ImportOmnivoreInboxUtil giutil, String deviceName) {
        this.giutil = giutil;
        this.deviceName = deviceName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean importFile(IVirtualFilesystemService.IVirtualFilesystemHandle file) {
        try {
            String baseFileName;
            IVirtualFilesystemService.IVirtualFilesystemHandle current = file.getParent();
            if (current == null) {
                return false;
            }
            ArrayList<String> segmentNames = new ArrayList<String>();
            String rawFileName = file.getName();
            String string = baseFileName = rawFileName.startsWith("_") ? rawFileName.substring(1) : rawFileName;
            while (true) {
                String documentName;
                String patientCandidate;
                String importedId;
                if (current == null) {
                    return false;
                }
                String name = current.getName();
                Matcher m = this.PATIENT_DIR_PATTERN.matcher(name);
                if (m.matches() && (importedId = this.giutil.tryImportForPatient(file, patientCandidate = m.group(1), documentName = this.buildDocumentName(baseFileName, segmentNames))) != null) {
                    this.log.info("Auto imported (HIERARCHY) file [{}], document id is [{}]", (Object)file, (Object)importedId);
                    return true;
                }
                if (!name.startsWith(".")) {
                    segmentNames.add(name);
                }
                current = current.getParent();
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to import file via hierarchy for [{}]", (Object)file, (Object)e);
        }
        return false;
    }

    private String buildDocumentName(String baseFileName, List<String> segments) {
        StringBuilder docNameBuilder = new StringBuilder();
        docNameBuilder.append(this.deviceName).append('_');
        if (!segments.isEmpty()) {
            int i = segments.size() - 1;
            while (i >= 0) {
                docNameBuilder.append(segments.get(i)).append('_');
                --i;
            }
        }
        docNameBuilder.append(baseFileName);
        return docNameBuilder.toString();
    }
}

