/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.core.handler;

import ch.elexis.core.exceptions.AccessControlException;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.TaskTriggerType;
import ch.elexis.global_inbox.core.handler.ImportOmnivoreIdentifiedRunnable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class TaskManagerHandler {
    private ITaskService taskService;

    public TaskManagerHandler(ITaskService taskService) {
        this.taskService = taskService;
    }

    public ITaskDescriptor getTaskDescriptorByReferenceId(String referenceId) {
        Optional taskDescriptorOpt = this.taskService.findTaskDescriptorByIdOrReferenceId(referenceId);
        return taskDescriptorOpt.orElse(null);
    }

    public void createAndConfigureTask(String referenceId, String destinationDir) {
        try {
            ImportOmnivoreIdentifiedRunnable test;
            Optional existingTaskDescriptorOpt = this.taskService.findTaskDescriptorByIdOrReferenceId(referenceId);
            ImportOmnivoreIdentifiedRunnable runnable = test = new ImportOmnivoreIdentifiedRunnable();
            if (existingTaskDescriptorOpt.isPresent()) {
                ITaskDescriptor taskDescriptor = (ITaskDescriptor)existingTaskDescriptorOpt.get();
                this.ensureNotDeletedById(taskDescriptor.getReferenceId());
                taskDescriptor.setTriggerParameter("url", destinationDir);
                taskDescriptor.setRunContextParameter("url", (Serializable)((Object)destinationDir));
                taskDescriptor.setRunContextParameter("destinationDir", (Serializable)((Object)destinationDir));
                taskDescriptor.setRunContextParameter("referenceId", (Serializable)((Object)referenceId));
                taskDescriptor.setActive(true);
                taskDescriptor.setRunner("ELEXIS-SERVER");
                this.taskService.saveTaskDescriptor(taskDescriptor);
                this.taskService.refresh(taskDescriptor);
            } else {
                ITaskDescriptor taskDescriptor = this.taskService.createTaskDescriptor((IIdentifiedRunnable)runnable);
                taskDescriptor.setReferenceId(referenceId);
                taskDescriptor.setTriggerType(TaskTriggerType.FILESYSTEM_CHANGE);
                taskDescriptor.setTriggerParameter("cron", destinationDir);
                taskDescriptor.setActive(true);
                taskDescriptor.setRunner("ELEXIS-SERVER");
                HashMap<String, String> runContext = new HashMap<String, String>();
                runContext.put("url", destinationDir);
                runContext.put("destinationDir", destinationDir);
                runContext.put("referenceId", referenceId);
                taskDescriptor.setRunContext(runContext);
                this.taskService.saveTaskDescriptor(taskDescriptor);
            }
        }
        catch (TaskException e) {
            e.printStackTrace();
        }
    }

    private void ensureNotDeletedById(String referenceId) {
        ITaskDescriptor taskDescriptor;
        Optional taskDescriptorOpt = this.taskService.findTaskDescriptorByIdOrReferenceId(referenceId);
        if (taskDescriptorOpt.isPresent() && (taskDescriptor = (ITaskDescriptor)taskDescriptorOpt.get()).getReferenceId().equals(referenceId)) {
            try {
                if (taskDescriptor.isDeleted()) {
                    taskDescriptor.setDeleted(false);
                    this.taskService.saveTaskDescriptor(taskDescriptor);
                }
            }
            catch (TaskException e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteTaskDescriptorByReferenceId(String referenceId) {
        Optional taskDescriptorOpt = this.taskService.findTaskDescriptorByIdOrReferenceId(referenceId);
        if (taskDescriptorOpt.isPresent()) {
            ITaskDescriptor taskDescriptor = (ITaskDescriptor)taskDescriptorOpt.get();
            try {
                taskDescriptor.setActive(false);
                taskDescriptor.setDeleted(true);
                this.taskService.setActive(taskDescriptor, false);
                this.taskService.saveTaskDescriptor(taskDescriptor);
            }
            catch (AccessControlException e) {
                LoggerFactory.getLogger(TaskManagerHandler.class).error("Berechtigungsfehler: " + e.getMessage());
            }
            catch (TaskException e) {
                e.printStackTrace();
            }
        }
    }
}

