/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.core.handler;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.global_inbox.core.strategies.FallbackStrategy;
import ch.elexis.global_inbox.core.strategies.FilePrefixStrategy;
import ch.elexis.global_inbox.core.strategies.HierarchyStrategy;
import ch.elexis.global_inbox.core.strategies.IImportStrategy;
import ch.elexis.global_inbox.core.strategies.PatientFolderStrategy;
import ch.elexis.global_inbox.core.util.ImportOmnivoreInboxUtil;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportOmnivore {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ImportOmnivoreInboxUtil giutil = new ImportOmnivoreInboxUtil();
    private String deviceName;

    public ImportOmnivore(String deviceName) {
        this.deviceName = deviceName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String filepath = ImportOmnivoreInboxUtil.getDirectory("", this.deviceName);
        IVirtualFilesystemService.IVirtualFilesystemHandle dir = null;
        if (filepath == null) {
            filepath = "";
            ConfigServiceHolder.get().set("plugins/global_inbox_server/dir", "");
        }
        try {
            dir = VirtualFilesystemServiceHolder.get().of(filepath);
            this.addFilesInDirRecursive(dir, true);
        }
        catch (Exception e) {
            this.log.error("Failed to convert filepath to directory. Filepath: {}", (Object)filepath, (Object)e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private int getPatientStrategyCode() {
        return ConfigServiceHolder.getGlobal((String)("global_inbox/patient_strategy_" + this.deviceName), (int)0);
    }

    private IImportStrategy getStrategy(int code) {
        switch (code) {
            case 0: {
                return new FilePrefixStrategy(this.giutil, this.deviceName);
            }
            case 1: {
                return new PatientFolderStrategy(this.giutil, this.deviceName);
            }
            case 2: {
                return new HierarchyStrategy(this.giutil, this.deviceName);
            }
        }
        return new FallbackStrategy(new FilePrefixStrategy(this.giutil, this.deviceName), new HierarchyStrategy(this.giutil, this.deviceName));
    }

    private void addFilesInDirRecursive(IVirtualFilesystemService.IVirtualFilesystemHandle dir, boolean isRoot) throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle[] files = dir.listHandles();
        if (files == null) {
            return;
        }
        int strategyCode = this.getPatientStrategyCode();
        IImportStrategy strategy = this.getStrategy(strategyCode);
        IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandleArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualFilesystemService.IVirtualFilesystemHandle file = iVirtualFilesystemHandleArray[n2];
            if (file.exists() && !file.getName().startsWith(".")) {
                if (file.isDirectory()) {
                    this.addFilesInDirRecursive(file, false);
                } else {
                    boolean imported = strategy.importFile(file);
                    if (!imported) {
                        this.log.debug("No import rule matched for file [{}] using strategy [{}]", (Object)file, (Object)strategy.getClass().getSimpleName());
                    }
                }
            }
            ++n2;
        }
        this.cleanupDirectory(dir, isRoot);
    }

    private void cleanupDirectory(IVirtualFilesystemService.IVirtualFilesystemHandle dir, boolean isRoot) throws IOException {
        if (!isRoot) {
            IVirtualFilesystemService.IVirtualFilesystemHandle[] remaining = dir.listHandles();
            boolean hasRealChildren = false;
            if (remaining != null) {
                IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandleArray = remaining;
                int n = remaining.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualFilesystemService.IVirtualFilesystemHandle h = iVirtualFilesystemHandleArray[n2];
                    if (h.exists() && !h.getName().startsWith(".")) {
                        hasRealChildren = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!hasRealChildren) {
                try {
                    dir.delete();
                    this.log.info("Deleted empty import folder [{}]", (Object)dir);
                }
                catch (IOException e) {
                    this.log.warn("Could not delete folder [{}]", (Object)dir, (Object)e);
                }
            }
        }
    }
}

