/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.core.handler;

import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.global_inbox.core.handler.ImportOmnivore;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;

public class ImportOmnivoreIdentifiedRunnable
implements IIdentifiedRunnable {
    private String eventFilePath;
    private String deviceName;

    public String getId() {
        return "importFileToOmnivore";
    }

    public String getLocalizedDescription() {
        return "Monitor a directory and import incoming files into the Omnivore";
    }

    public synchronized Map<String, Serializable> run(Map<String, Serializable> context, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        this.eventFilePath = null;
        this.deviceName = null;
        for (Map.Entry<String, Serializable> entry : context.entrySet()) {
            String key = entry.getKey();
            Serializable value = entry.getValue();
            if ("url".equals(key)) {
                this.eventFilePath = (String)((Object)value);
                continue;
            }
            if (!"referenceId".equals(key)) continue;
            this.deviceName = (String)((Object)value);
        }
        if (this.eventFilePath == null || this.deviceName == null) {
            throw new TaskException(6, "Missing required run-context-parameter(s): [url, destinationDir, referenceId]");
        }
        try {
            IStatus status = new ImportOmnivore(this.deviceName).run(progressMonitor);
            if (!status.isOK()) {
                throw new TaskException(6, "Import failed with status: " + status.getMessage());
            }
        }
        catch (Exception ex) {
            throw new TaskException(6, "An error occurred during the import process: " + ex.getMessage());
        }
        return null;
    }

    public Map<String, Serializable> getDefaultRunContext() {
        return Collections.singletonMap("url", "DefaultURLValue");
    }
}

