/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.fop.service.jaxb;

import ch.elexis.fop.service.FormattedOutputFactory;
import ch.elexis.fop.service.JaxbUtil;
import ch.elexis.fop.service.XSLTUtil;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbToMimeType {
    private static Logger logger = LoggerFactory.getLogger(JaxbToMimeType.class);
    private static JaxbToMimeType instance;

    private JaxbToMimeType() {
    }

    public static JaxbToMimeType getInstance() {
        if (instance == null) {
            instance = new JaxbToMimeType();
        }
        return instance;
    }

    public void transform(Object jaxbObject, InputStream xslt, OutputStream outputStream, String outputFormat, Map<String, String> transformerParameters, URIResolver resolver) {
        FOUserAgent foUserAgent = FormattedOutputFactory.getFopFactory().newFOUserAgent();
        try {
            try {
                Fop fop = FormattedOutputFactory.getFopFactory().newFop(outputFormat, foUserAgent, outputStream);
                Transformer transformer = XSLTUtil.getTransformerForXSLT(xslt, resolver);
                if (transformerParameters != null && transformerParameters.keySet().size() > 0) {
                    for (String keyParameter : transformerParameters.keySet()) {
                        transformer.setParameter(keyParameter, transformerParameters.get(keyParameter));
                    }
                }
                ByteArrayOutputStream output = JaxbUtil.getOutputStreamForObject(jaxbObject);
                StreamSource src = new StreamSource(new ByteArrayInputStream(output.toByteArray()));
                SAXResult res = new SAXResult(fop.getDefaultHandler());
                transformer.transform(src, res);
            }
            catch (TransformerException e) {
                logger.error("Error during XML tranformation.", (Throwable)e);
                throw new IllegalStateException(e);
            }
            catch (FOPException e) {
                logger.error("Error during XML tranformation.", (Throwable)e);
                throw new IllegalStateException(e);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Error during XML tranformation.", (Throwable)e);
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                logger.error("Error during XML tranformation.", (Throwable)e);
                throw new IllegalStateException(e);
            }
            catch (JAXBException e) {
                logger.error("Error during XML tranformation.", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

